
/*
 * seq_list.c -- get all messages in a sequence and return them
 *            -- as a space separated list of message ranges
 *
 * $Id$
 */

#include <h/mh.h>


char *
seq_list(struct msgs *mp, char *seqname)
{
    int i, j, seqnum;
    char *bp;
    static char buffer[BUFSIZ*2];	/* for big sequences */

    /*
     * Special processing for "cur" sequence.
     * We assume that "cur" sequence and mp->curmsg
     * are in sync - see seq_add.c
     */
    if (!strcmp (current, seqname)) {
	if (mp->curmsg) {	
	    sprintf(buffer, "%s", m_name(mp->curmsg));
	    return (buffer);
	} else
	    return (NULL);
    }

    /* get the index of the sequence */
    if ((seqnum = seq_getnum (mp, seqname)) == -1)
	return NULL;

    bp = buffer;

    for (i = mp->lowmsg; i <= mp->hghmsg; ++i) {
	/*
	 * If message doesn't exist, or isn't in
	 * the sequence, then continue.
	 */
	if (!does_exist(mp, i) || !in_sequence(mp, seqnum, i))
	    continue;

	if (bp > buffer)
	    *bp++ = ' ';

	sprintf(bp, "%s", m_name(i));
	bp += strlen(bp);
	j = i;
	for (++i; i <= mp->hghmsg && does_exist(mp, i) && in_sequence(mp, seqnum, i);
	     ++i)
	    ;
	if (i - j > 1) {
	    sprintf(bp, "-%s", m_name(i - 1));
	    bp += strlen(bp);
	}
    }
    return (bp > buffer? buffer : NULL);
}
