
/*
 * packf.c -- pack a nmh folder into a file
 *
 * $Id$
 */

#include <h/mh.h>
#include <fcntl.h>
#include <h/dropsbr.h>
#include <errno.h>

static struct swit switches[] = {
#define FILESW         0
    { "file name", 0 },
#define MBOXSW         1
    { "mbox", 0 },
#define MMDFSW         2
    { "mmdf", 0 },
#define VERSIONSW      3
    { "version", 0 },
#define	HELPSW         4
    { "help", 4 },
    { NULL, 0 }
};

extern int errno;

static int md = NOTOK;
static int mbx_style = MBOX_FORMAT;
static int mapping = 0;

char *file = NULL;


int
main (int argc, char **argv)
{
    int msgp = 0, fd, msgnum;
    char *cp, *maildir, *msgnam, *folder = NULL, buf[100];
    char **ap, **argp, *arguments[MAXARGS], *msgs[MAXARGS];
    struct msgs *mp;
    struct stat st;

#ifdef LOCALE
    setlocale(LC_ALL, "");
#endif
    invo_name = r1bindex (argv[0], '/');
    if ((cp = m_find (invo_name)) != NULL) {
	ap = brkstring (cp = getcpy (cp), " ", "\n");
	ap = copyip (ap, arguments);
    } else {
	ap = arguments;
    }
    copyip (argv + 1, ap);
    argp = arguments;

    while ((cp = *argp++)) {
	if (*cp == '-')
	    switch (smatch (++cp, switches)) {
		case AMBIGSW: 
		    ambigsw (cp, switches);
		    done (1);
		case UNKWNSW: 
		    adios (NULL, "-%s unknown", cp);

		case HELPSW: 
		    sprintf (buf, "%s [+folder] [msgs] [switches]", invo_name);
		    print_help (buf, switches);
		    done (1);
		case VERSIONSW:
		    print_version(invo_name);
		    done (1);

		case FILESW: 
		    if (file)
			adios (NULL, "only one file at a time!");
		    if (!(file = *argp++) || *file == '-')
			adios (NULL, "missing argument to %s", argp[-2]);
		    continue;

		case MBOXSW:
		    mbx_style = MBOX_FORMAT;
		    mapping = 0;
		    continue;
		case MMDFSW:
		    mbx_style = MMDF_FORMAT;
		    mapping = 1;
		    continue;
	    }
	if (*cp == '+' || *cp == '@') {
	    if (folder)
		adios (NULL, "only one folder at a time!");
	    folder = path (cp + 1, *cp == '+' ? TFOLDER : TSUBCWF);
	}
	else
	    msgs[msgp++] = cp;
    }

    if (!file)
	file = "./msgbox";
    file = path (file, TFILE);
    if (stat (file, &st) == NOTOK) {
	if (errno != ENOENT)
	    adios (file, "error on file");
	cp = concat ("Create file \"", file, "\"? ", NULL);
	if (!getanswer (cp))
	    done (1);
	free (cp);
    }

    if (!m_find ("path"))
	free (path ("./", TFOLDER));
    if (!msgp)
	msgs[msgp++] = "all";
    if (!folder)
	folder = m_getfolder ();
    maildir = m_maildir (folder);

    if (chdir (maildir) == NOTOK)
	adios (maildir, "unable to change directory to ");

    /* read folder and create message structure */
    if (!(mp = m_readfolder (folder)))
	adios (NULL, "unable to read folder %s", folder);

    if (mp->hghmsg == 0)
	adios (NULL, "no messages in %s", folder);

    /* parse all the message ranges/sequences and set SELECTED */
    for (msgnum = 0; msgnum < msgp; msgnum++)
	if (!m_convert (mp, msgs[msgnum]))
	    done (1);
    seq_setprev (mp);	/* set the previous-sequence */

    if ((md = mbx_open(file, mbx_style, getuid(), getgid(), m_gmprot())) == NOTOK)
	adios (file, "unable to open");

    /* copy all the SELECTED messages to the file */
    for (msgnum = mp->lowsel; msgnum <= mp->hghsel; msgnum++)
	if (is_selected(mp, msgnum)) {
	    if ((fd = open (msgnam = m_name (msgnum), O_RDONLY)) == NOTOK) {
		admonish (msgnam, "unable to read message");
		break;
	    }

	    if (mbx_copy (file, mbx_style, md, fd, mapping, NULL, 1) == NOTOK)
		adios (file, "error writing to file");

	    close (fd);
	}
    mbx_close (file, md);

    m_replace (pfolder, folder);	/* update current folder         */
    if (mp->hghsel != mp->curmsg)
	seq_setcur (mp, mp->lowsel);
    seq_save (mp);
    m_freefolder (mp);			/* free folder/message structure */
    m_update ();			/* update the context file       */
    done (0);
}

void
done (int status)
{
    mbx_close (file, md);
    exit (status);
}
