
/*
 * m_draft.c -- construct the draft name
 *
 * $Id$
 */

#include <h/mh.h>
#include <errno.h>

extern int errno;


char *
m_draft (char *folder, char *msg, int use, int *isdf)
{
    register char *cp;
    register struct msgs *mp;
    struct stat st;
    static char buffer[BUFSIZ];

    if (*isdf == NOTOK || folder == NULL || *folder == 0) {
	if (*isdf == NOTOK || (cp = m_find ("Draft-Folder")) == NULL) {
	    *isdf = 0;
	    return m_maildir (msg && *msg ? msg : draft);
	}
	else
	    folder = path (*cp == '+' || *cp == '@' ? cp + 1 : cp,
		    *cp != '@' ? TFOLDER : TSUBCWF);
    }
    *isdf = 1;
    
    chdir (m_maildir (""));
    strcpy (buffer, m_maildir (folder));
    if (stat (buffer, &st) == NOTOK) {
	if (errno != ENOENT)
	    adios (buffer, "error on folder");
	cp = concat ("Create folder \"", buffer, "\"? ", NULL);
	if (!getanswer (cp))
	    done (0);
	free (cp);
	if (!makedir (buffer))
	    adios (NULL, "unable to create folder %s", buffer);
    }

    if (chdir (buffer) == NOTOK)
	adios (buffer, "unable to change directory to");
    if (!(mp = m_gmsg (folder)))
	adios (NULL, "unable to read folder %s", folder);

    if ((mp = m_remsg (mp, 0, MAXFOLDER)) == NULL)
	adios (NULL, "unable to allocate folder storage");
    mp->msgflags |= MHPATH;

    if (!m_convert (mp, msg && *msg ? msg : use ? "cur" : "new"))
	done (1);
    m_setseq (mp);
    if (mp->numsel > 1)
	adios (NULL, "only one message draft at a time!");

    sprintf (buffer, "%s/%s", mp->foldpath, m_name (mp->lowsel));
    cp = buffer;

    m_setcur (mp, mp->lowsel);
    m_sync (mp);
    m_fmsg (mp);

    return cp;
}
