
/*
 * getans.c -- get an answer from the user and return a string array
 */

#ifndef	lint
static char ident[] = "$Id$";
#endif	/* lint */

#include "../h/nmh.h"
#include "../h/mh.h"
#include <setjmp.h>
#include <signal.h>
#include <stdio.h>

static char ansbuf[BUFSIZ];
static jmp_buf sigenv;

/*
 * static prototypes
 */
static RETSIGTYPE intrser (int);;


char **
getans (char *prompt, struct swit *ansp)
{
    int i;
    RETSIGTYPE (*istat)();
    char *cp, **cpp;

    if (!(setjmp (sigenv))) {
	istat = signal (SIGINT, intrser);
    } else {
	signal (SIGINT, istat);
	return NULL;
    }

    for (;;) {
	printf ("%s", prompt);
	fflush (stdout);
	cp = ansbuf;
	while ((i = getchar ()) != '\n') {
	    if (i == EOF)
		longjmp (sigenv, 1);
	    if (cp < &ansbuf[sizeof ansbuf - 1])
		*cp++ = i;
	}
	*cp = 0;
	if (ansbuf[0] == '?' || cp == ansbuf) {
	    printf ("Options are:\n");
	    print_sw (ALL, ansp, "");
	    continue;
	}
	cpp = brkstring (ansbuf, " ", NULLCP);
	switch (smatch (*cpp, ansp)) {
	    case AMBIGSW: 
		ambigsw (*cpp, ansp);
		continue;
	    case UNKWNSW: 
		printf (" -%s unknown. Hit <CR> for help.\n", *cpp);
		continue;
	    default: 
		signal (SIGINT, istat);
		return cpp;
	}
    }
}


static RETSIGTYPE
intrser (int i)
{
    longjmp (sigenv, 1);  /* should this be siglongjmp? */
}
