.\"
.\" %nmhwarning%
.\" $Id$
.\"
.\" include the -mh macro file
.so %etcdir%/tmac.h
.\"
.TH MSH %manext1% MH.6.8 [%nmhversion%]
.SH NAME
msh \- MH shell (and BBoard reader)
.SH SYNOPSIS
.in +.5i
.ti -.5i
msh
\%[\-prompt\ string]
\%[\-scan] \%[\-noscan]
\%[\-topcur] \%[\-notopcur]
\%[file]
\%[\-version]
\%[\-help]
.in -.5i
.SH DESCRIPTION
\fImsh\fR is an interactive program that
implements a subset of the normal \fIMH\fR commands
operating on a single file in \fIpackf\fR'd format.
That is, \fImsh\fR is used to read a file that contains a number of
messages,
as opposed to the standard
\fIMH\fR
style of reading a number of files,
each file being a separate message in a folder.
\fImsh\fR's chief advantage is that the normal \fIMH\fR style does not allow
a file to have more than one message in it.
Hence, \fImsh\fR is ideal for reading \fIBBoards\fR,
as these files are delivered by the transport system in this format.
In addition, \fImsh\fR can be used on other files,
such as message archives which have been \fIpack\fRed (see \fIpackf\fR\0(1)).
Finally, \fImsh\fR is an excellent \fIMH\fR
tutor.
As the only commands available to the user are \fIMH\fR commands,
this allows \fIMH\fR beginners to concentrate on how commands to
\fIMH\fR are formed and (more or less) what they mean.

When invoked, \fImsh\fR reads the named file, and enters a command loop.
The user may type most of the normal
\fIMH\fR
commands.
The syntax and semantics of these commands typed to \fImsh\fR are
identical to their \fIMH\fR
counterparts.  In cases where the nature of \fImsh\fR would be inconsistent
(e.g., specifying a `+folder' with some commands),
\fImsh\fR will duly inform the user.
The commands that \fImsh\fR currently supports
(in some slightly modified or restricted forms) are:
.sp 1
.in +.5i
ali
.br
burst
.br
comp
.br
dist
.br
folder
.br
forw
.br
inc
.br
mark
.br
mhmail
.br
mhn
.br
msgchk
.br
next
.br
packf
.br
pick
.br
prev
.br
refile
.br
repl
.br
rmm
.br
scan
.br
send
.br
show
.br
sortm
.br
whatnow
.br
whom
.in -.5i

In addition,
\fImsh\fR has a \*(lqhelp\*(rq command which gives a brief overview.
To terminate \fImsh\fR, type CTRL\-D, or use the \*(lqquit\*(rq command.
If \fImsh\fR is being invoked from \fIbbc\fR,
then typing CTRL\-D will also tell \fIbbc\fR to exit as well,
while using the \*(lqquit\*(rq command will return control to \fIbbc\fR,
and \fIbbc\fR will continue examining the list of BBoards
that it is scanning.

If the file is writable and has been modified,
then using \*(lqquit\*(rq will query the user if the file should be updated.

The `\-prompt string' switch sets the prompting string for \fImsh\fR.

You may wish to use an alternate \fIMH\fR profile for the commands that
\fImsh\fR executes;
see \fImh-profile\fR\0(5) for details about the \fB$MH\fR envariable.

When invoked from \fIbbc\fR,
two special features are enabled:
First,
the `\-scan' switch directs \fImsh\fR to do a `scan\0unseen' on
start\-up if new items are present in the BBoard.
This feature is best used from \fIbbc\fR,
which correctly sets the stage.
Second,
the \fImark\fR command in \fImsh\fR acts specially when you are reading
a BBoard,
since \fImsh\fR will consult the sequence \*(lqunseen\*(rq in determining
what messages you have actually read.
When \fImsh\fR exits, it reports this information to \fIbbc\fR.
In addition, if you give the \fImark\fR command with no arguments,
\fImsh\fR will interpret it
as `mark\0\-sequence\0unseen\0\-delete\0\-nozero\0all'
Hence, to discard all of the messages in the current BBoard you're
reading, just use the \fImark\fR command with no arguments.

Normally, the \*(lqexit\*(rq command is identical to the \*(lqquit\*(rq
command in \fImsh\fR.
When run under \fIbbc\fR however, \*(lqexit\*(rq directs \fImsh\fR to mark
all messages as seen and then \*(lqquit\*(rq.
For speedy type\-in,
this command is often abbreviated as just \*(lqe\*(rq.

When invoked from \fIvmh\fR,
another special feature is enabled:
The `topcur' switch directs \fImsh\fR to have the current message
\*(lqtrack\*(rq the top line of the \fIvmh\fR scan window.
Normally, \fImsh\fR has the current message \*(lqtrack\*(rq the center of the
window (under `\-notopcur', which is the default).

\fImsh\fR supports an output redirection facility.
Commands may be followed by one of

.nf
.in +.5i
.ta \w'| \fIcommand\fR  'u
^> \fIfile\fR~^write output to \fIfile\fR
^>> \fIfile\fR~^append output to \fIfile\fR
^| \fIcommand\fR~^pipe output to UNIX \fIcommand\fR
.re
.in -.5i
.fi

If \fIfile\fR starts with a `\~' (tilde),
then a \fIcsh\fR-like expansion takes place.
Note that \fIcommand\fR is interpreted by \fIsh\fR\0(1).
Also note that \fImsh\fR does NOT support
history substitutions, variable substitutions, or alias substitutions.

When parsing commands to the left of any redirection symbol,
\fImsh\fR will honor `\\' (back\-slash) as the quote next\-character symbol,
and `"' (double\-quote) as quote\-word delimiters.
All other input tokens are separated by whitespace
(spaces and tabs).
.Fi
^$HOME/\&.mh\(ruprofile~^The user profile
^%etcdir%/mtstailor~^tailor file
.Pr
^Path:~^To determine the user's MH directory
.Ps
^Msg\-Protect:~^To set mode when creating a new `file'
.Ps
^fileproc:~^Program to file messages
.Ps
^showproc:~^Program to show messages
.Sa
bbc(1)
.De
`file' defaults to \*(lq./msgbox\*(rq
.Ds
`\-prompt\ (msh)\ '
.Ds
`\-noscan'
.Ds
`\-notopcur'
.Co
None
.Bu
The argument to the `\-prompt' switch must be interpreted as a single token
by the shell that invokes \fImsh\fR.
Therefore,
one must usually place the argument to this switch inside double\-quotes.

There is a strict limit of messages per file in \fIpackf\fR'd format which
\fImsh\fR can handle.
Usually, this limit is 1000 messages.

Please remember that \fImsh\fR is not the \fICShell\fR,
and that a lot of the nice facilities provided by the latter are not
present in the former.

In particular, \fImsh\fR does not understand back\-quoting,
so the only effective way to use \fIpick\fR inside \fImsh\fR is to always use
the `\-seq\0select' switch.
Clever users of \fIMH\fR will put the line

.ti +.5i
pick:\0\-seq\0select\0\-list

in their \&.mh\(ruprofile file so that \fIpick\fR works equally well from
both the shell and \fImsh\fR.

\fIsortm\fR always uses \*(lq\-noverbose\*(rq and
if \*(lq\-textfield\ field\*(lq is used, \*(lq\-limit 0\*(rq.

The \fImsh\fR program inherits most (if not all) of the bugs from the
\fIMH\fR commands it implements.
.En
