#!/bin/sh
#
# $Id$
#
# Small script to create version string for nmh.
# You need to pass the script the version number to use.

OFS="$IFS" IFS=:

# find out the name of the host we are compiling on
for prog in uname hostname
do
    for dir in $PATH
    do
	if [ ! -f $dir/$prog ]; then
	    continue
	fi
	case $prog in
	    uname)	host=`$prog -n`
			;;
	    hostname)	host=`$prog`
			;;
	esac
	break
    done
    if [ "x$HOSTNAME" != x ]; then
	break
    fi
done

IFS=" "

echo "char *version = \"nmh-$1 [compiled on $host at `date`]\";"
