#!/usr/bin/perl
eval "exec /usr/bin/perl -S $0 $*"
    if $running_under_some_shell;
    # this emulates #! processing on NIH machines.
    # (remove #! line above if indigestible)


# checkalias.pl, an elm-style checkalias script for showing the address
# of mutt aliases.
#
# Author: Mikko Hnninen <Mikko.Hanninen@iki.fi>, 25 Oct 1997

require "getopts.pl";

do Getopts('hf:') && !($opt_h) ||
        die "Usage: $0 [-h] [-f mailalias file] aliases...\n";


if ($opt_f) { $aliasfile = $opt_f; }
else { $aliasfile = $ENV{HOME} . "/.muttrc"; }
@checkaliases = @ARGV;


open(ALIASES, "<$aliasfile") || die("Couldn't open $aliasfile for reading: $!");
while (<ALIASES>) {
  chomp;
  if (/^\s*alias\s+(\S+)\s+([^<]+)\s+(<.+>)\s*$/i) {
    $alias = $1;
    $name = $2;
    $address = $3;
    foreach (@checkaliases) {
      print "$alias is \"$name\", mail sent to $address\n" if $_ eq $alias;
    }
  }
}
close(ALIASES);

