/* pidwait.c - wait for child to exit */
#ifndef	lint
static char ident[] = "@(#)$Id: pidwait.c,v 1.5 1992/01/29 23:57:28 jromine Exp $";
#endif	lint

#include "../h/mh.h"
#include <signal.h>
#include <stdio.h>
#ifdef	BSD42
#include <sys/wait.h>
#endif	BSD42


int     pidwait (id, sigsok)
register int     id,
		 sigsok;
{
    register int    pid;
    TYPESIG (*hstat) (), (*istat) (), (*qstat) (), (*tstat) ();
#ifndef	BSD42
    int     status;
#else	BSD42
    union wait status;
#endif	BSD42

    if (sigsok == NOTOK) {
#ifdef	notdef		/* I don't see why to trap these... */
	hstat = signal (SIGHUP, SIG_IGN);
	tstat = signal (SIGTERM, SIG_IGN);
#endif
	istat = signal (SIGINT, SIG_IGN);
	qstat = signal (SIGQUIT, SIG_IGN);
    }

    while ((pid = wait (&status)) != NOTOK && pid != id)
	continue;

    if (sigsok == NOTOK) {
#ifdef	notdef
	(void) signal (SIGHUP, hstat);
	(void) signal (SIGTERM, tstat);
#endif
	(void) signal (SIGINT, istat);
	(void) signal (SIGQUIT, qstat);
    }

#ifndef	BSD42
    return (pid == NOTOK ? NOTOK : status);
#else	BSD42
    return (pid == NOTOK ? NOTOK : status.w_status);
#endif	BSD42
}
