#!/usr/local/bin/wish -f
# 
# Here is a simple TCL-based richtext interpreter.  It doesn't do a lot yet.
# (It also crashes the OpenWindows server on my Sun, so I don't know if it
# will crash yours.  I'm still looking into the crash thing.)  Once the
# crash thing is fixed, I'll add more to it...
# 
# Anyway, try this:
# 
# 	wish -f richtext.tcl < file.rt
# 
# and see what you think!
# 
# /mtr
# 
# 
proc	richtext		{{w .richtext}} {
    catch	{destroy $w}
    toplevel	$w
    wm title	$w		"Richtext"
    wm iconname	$w		"rt"

    text	$w.text		-borderwidth 2 \
				-height 34 \
				-relief raised \
				-setgrid true \
				-width 80 \
				-wrap word \
				-yscrollcommand "$w.scroll set"
    scrollbar	$w.scroll	-command "$w.text yview" \
				-relief flat
    frame	$w.bot		-borderwidth 1
    pack append	$w.bot		[button $w.bot.button \
					-command "destroy $w;destroy ." \
					-text Dismiss] \
				    {top padx 5 pady 5 expand}

    pack append	$w		$w.bot \
				    {bottom fillx} \
				$w.scroll \
				    {right filly} \
				$w.text \
				    {expand fill}

    $w.text tag	configure	bold \
					-font -*-courier-bold-r-normal-*-120-*
    $w.text tag configure	italic \
					-font -*-courier-medium-o-normal-*-120-*
    $w.text tag configure	bolditalic \
					-font -*-courier-bold-o-normal-*-120-*
    $w.text tag configure	fixed \
					-font -*-courier-medium-r-normal-*-120-*

    $w.text tag configure	bigbold \
					-font -*-courier-bold-r-normal-*-140-*
    $w.text tag configure	bigitalic \
					-font -*-courier-medium-o-normal-*-140-*
    $w.text tag configure	bigbolditalic \
					-font -*-courier-bold-o-normal-*-140-*
    $w.text tag configure	bigfixed \
					-font -*-courier-medium-r-normal-*-140-*

    $w.text tag configure	smallbold \
					-font -*-courier-bold-r-normal-*-100-*
    $w.text tag configure	smallitalic \
					-font -*-courier-medium-o-normal-*-100-*
    $w.text tag configure	smallbolditalic \
					-font -*-courier-bold-o-normal-*-100-*
    $w.text tag configure	smallfixed \
					-font -*-courier-medium-r-normal-*-100-*

    $w.text tag configure	underline \
					-underline on


    set		env(bold)	0
    set		env(italic)	0
    set		env(fixed)	0
    set		env(smaller)	0
    set		env(bigger)	0
    set		env(underline)	0

    set		env(center)	0
    set		env(flushleft)	0
    set		env(flushright)	0
    set		env(indent)	0
    set		env(indentright) 0
    set		env(outdent)	0
    set		env(outdentright) 0
    set		env(samepage)	0
    set		env(superscript) 0
    set		env(subscript)	0
    set		env(heading)	0
    set		env(footing)	0
    set		env(excerpt)	0
    set		env(paragraph)	0
    set		env(signature)	0

    set		intoken		0
    set		token		""

    set		incomment	0

    set		output		""
    set		lasto		" "


    while {[gets stdin buffer] > -1} {
	set	len		[string length $buffer]

	if {(!$intoken) && ($lasto != " ")} {
	    append	output	[set lasto " "]
	}

	for {set i 0} {$i < $len} {incr i} {
	    set	c		[string index $buffer $i]
	    if {$intoken} {
		if {([string length $token] == 0) && ($c == "/")} {
		    set	intoken	-1
		    continue
		}
		if {$c != ">"} {
		    append	token	$c
		    continue
		}

		set	command	[string tolower $token]
		set	pos	$intoken

		set	intoken	0
		set	token	""

		if {$command == "comment"} {
		    if {[incr incomment $pos] < 0} {
			set	incomment	0
		    }
		    if {$incomment > 0} {	continue }
		}

		if {$command == "lt"} {
		    append	output	[set lasto "<"]
		    continue
		}
		if {($command == "nl") || ($command == "np")} {
		    append	output	"\n"
		    set		lasto	" "
		    continue
		}

		if {[string length $output]} {
		    set	size	[expr $env(bigger)-$env(smaller)]
		    if {$size > 0} {
		        set	font	"big"
		    } else {
		        if {$size < 0} {
			    set	font	"small"
		        } else {
			    set	font	""
		        }
		    }
		    if {$env(fixed) > 0} {
		        append	font	"fixed"
		    } else {
		        if {$env(bold) > 0} {
			    append	font	"bold"
		        }
		        if {$env(italic) > 0} {
			    append	font	"italic"
		        }
		    }
		    set	tags	[list $font]
		    if {$env(underline) > 0} {
		        append	tags	underline
		    }

		    insertWithTags	$w.text $output $tags

		    set	output		""
		    set	lasto		" "
		}

		catch	{
		    if {[incr env($command) $pos] < 0} {
			set $env($command) 0
		    }
		}
		continue
	    }

	    if {$c != "<"} {
		if {!$incomment} {
		    append	output	[set lasto $c]
		}
		continue
	    }

	    set	intoken		1
	}
    }

    insertWithTags $w.text	$output
}

# The procedure below inserts text into a given text widget and
# applies one or more tags to that text.  The arguments are:
#
# w		Window in which to insert
# text		Text to insert (it's inserted at the "insert" mark)
# args		One or more tags to apply to text.  If this is empty
#		then all tags are removed from the text.

proc insertWithTags {w text args} {
    set start [$w index insert]
    $w insert insert $text
    foreach tag [$w tag names $start] {
	$w tag remove $tag $start insert
    }
    foreach i $args {
	$w tag add $i $start insert
    }
}


richtext
wm withdraw .
