/*
 * fakesendmail.c
 *	This program implements the ``-t'' option of sendmail (q.v.)
 *	for those who are unfortunate enough, not to have a sendmail
 *	or another MTA that handles this implemeted on their system.
 *	
 *	What the ``-t'' option does is that it says to the MTA: "I
 *	won't give you the recipients on the command line, but find
 *	them yourself in the RFC-822 headers included in the message,
 *	and please remove any "Bcc:" headers before sending."
 *
 *	What this program does is basically to do the above and feed
 *	the result to rmail (q.v.).
 *	
 *	It is used in the program splitmail (included in the metamail
 *	package) and is activated by setting the NO_SENDMAIL in the
 *	global Makefile, and possibly edit the path in config.h.
 *
 * NOTE:
 *	This program was made on an ESIX System V Release 4, and may
 *	require some twistings on the parameters for rmail (or other
 *	MTA program used) to get the synchronous/asynchronous delivery
 *	mode set.
 *	
 * (c) Copyright 1993 by Internet Consult, Kim Chr. Madsen
 *     All Rights Reserved
 *	
 *	Permission to use, copy, modify, and distribute this material
 *	for any purpose and without fee is hereby granted, provided
 *	that the above copyright notice and this permission notice
 *	appear in all copies, and that the name of Internet Consult
 *	not be used in advertising or publicity pertaining to this
 *	material without the specific, prior written permission of an
 *	authorized representative of Internet Consult.  INTERNET
 *	CONSULT MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR
 *	SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
 *	"AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES. 
 *
 */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <varargs.h>

#include "../config.h"

#define	VERSION		"Version 0.4 (beta)"

#define	ADDRESSLEN	512			/* Should be enough */
#define	LINELEN		1024			/* Max input line len. */
#define	HEADERLEN	5*LINELEN		/* Combined max len. */
#define	RMAIL		"/usr/bin/rmail"	/* Usable MTA program */
#define	ASYNC_OPT	" -w"			/* Asynchronous delivery */

#define	OTHERLINE	0
#define	TOLINE		1
#define	CCLINE		2
#define	BCCLINE		3

/* codes for error() */
#define	DEBUG		0
#define	EXIT		1
#define	DIE		2

struct address_stack {
	char			as_mail[ADDRESSLEN];
	struct address_stack	*next;
};
typedef struct address_stack	STACK;

STACK	*astack;
int	debug = 0;
char	*prog;

extern char	*tmpnam();
extern void	error();
extern void	str_append();
extern void	add_names();
extern STACK	*push();

main(argc,argv)
int	argc;
char	*argv[];
{
	extern char	*optarg;
	extern int	optind;
	int		c;
	char		line[LINELEN];
	char		cmd[HEADERLEN];
	char		*pass_opts;
	char		*fname;
	FILE		*f, *pf;
	int		verbose	= 0;
	int		tflag	= 0;
	int		errflg	= 0;
	int		async	= 1;
	int		status;
	STACK		*tmp;
	
	if (!(prog=rindex(argv[0],'/'))) prog = argv[0];
	pass_opts = "";
	
	while ((c=getopt(argc,argv,"Vvdtp:")) != EOF)
		switch (c) {
		case 'V':
			fprintf(stderr,"%s\n",VERSION);
			exit(0);
		case 'v':
			verbose++;
			async = 0;
			error(DEBUG,"Verbose and Synchronous delivery set");
			break;
		case 'd':
			debug++;
			error(DEBUG,"Debugging info enabled");
			break;
		case 't':
			tflag++;
			error(DEBUG,"Reading recipients from stdin");
			break;
		case 'p':
			pass_opts = optarg;
			error(DEBUG,"Passing options: \"%s\" to %s",
			      pass_opts,RMAIL);
			break;
		default:
			errflg++;
			break;
		}
	if (errflg) {
		fprintf(stderr,
			"usage: %s [-V] [-v] [-t|address ...] [-p opt]\n",
			prog);
		exit(1);
	}
	astack = (STACK *) NULL;
	
	if (tflag && optind<argc)
		error(DIE,"extraneous argument(s)");
	if (!tflag && optind>=argc)
		error(DIE,"Either use -t or specify mail recipients");
	while (!tflag && optind < argc)
		astack = push(astack,argv[optind++]);

	if (tflag) {
		fname = tmpnam((char *) 0);
		if (!(f=fopen(fname,"w")))
			error(DIE,"Cannot open temporary file: %s",fname);
		parse_headers(f);
		fclose(f);
	}
	if (astack == (STACK *) NULL)
		error(DIE,"No recipients found!!!");
	
	sprintf(cmd,"%s%s %s",RMAIL,async ? ASYNC_OPT : "",pass_opts);
	for (tmp = astack; tmp != (STACK *) NULL; tmp=tmp->next) {
		str_append(cmd,tmp->as_mail,HEADERLEN);
		str_append(cmd," ",HEADERLEN);
	}
	error(DEBUG,cmd);
	if (!(pf=popen(cmd,"w")))
		error(DIE,"Cannot open pipeline to %s",RMAIL);
	if (tflag) {
		if (!(f=fopen(fname,"r")))
			error(DIE,"Cannot open temporary file %s",fname);
		while (fgets(line,LINELEN,f)) {
			fputs(line,pf);
			if (debug) fputs(line,stderr);
		}
		fputs("\n",pf);
		if (debug) fputs("\n",stderr);
	}
	while (fgets(line,LINELEN,stdin)) {
		fputs(line,pf);
		if (debug) fputs(line,stderr);
	}
	status = pclose(pf);
	error(DEBUG,"%s returned %d",RMAIL,status);
	(void) unlink(fname);
}

int parse_headers(f)
FILE	*f;
{
	char	line[LINELEN];
	char	header[HEADERLEN];
	int	last = OTHERLINE;

	*header = 0;
	while (fgets(line,LINELEN,stdin)) {
		if (*line == '\n' || *line == '\r') {
			if (last) add_names(header);
			return(1);
		}
		if (isspace(*line)) {
			/*
			 * header-lines starting with whitespace is
			 * continuation lines...
			 */
			str_append(header,line,HEADERLEN);
			if (last == BCCLINE) continue;
		} else if (!strncmp(line,"To:",3)) {
			if (last) {
				str_append(header,",",HEADERLEN);
				str_append(header,line+3,HEADERLEN);
			} else	strcpy(header,line+3);
			last = TOLINE;
		} else if (!strncmp(line,"Cc:",3)) {
			if (last) {
				str_append(header,",",HEADERLEN);
				str_append(header,line+3,HEADERLEN);
			} else	strcpy(header,line+3);
			last = CCLINE;
		} else if (!strncmp(line,"Bcc:",4)) {
			if (last) {
				str_append(header,",",HEADERLEN);
				str_append(header,line+4,HEADERLEN);
			} else	strcpy(header,line+4);
			last = BCCLINE;
			continue;
		} else {
			if (last) {
				add_names(header);
			}
			*header = 0;
			last = OTHERLINE;
		}
		fputs(line,f);
	}
	return(0);		/* shouldn't happen unless debugging */
}

void add_names(str)
char	*str;
{
	char	address[ADDRESSLEN], new[ADDRESSLEN];
	char	*p, *q, *s;
	
	for (s = str; *s;) {
		for (p=address; *s && *s != ','; s++) 
			if (!isspace(*s)) *p++ = *s;
		if (*s == ',') s++;
		*p = 0;
		
		if ((p=index(address,'<'))	&&
		    (q=rindex(address,'>'))	&&
		    (q>p)) {
			/* form: [comment]<address> */
			*q = 0;
			astack = push(astack,p+1);
		} else {
			/* form: address[(comment)] */
			for (p=address,q=new; *p;) {
				if (*p == '(') {
					while (*p && *p != ')') p++;
					if (*p) p++;
				}
				*q++ = *p++;
			}
			*q = 0;
			astack = push(astack,new);
		}
		while (*s && isspace(*s)) s++;
	}
}

STACK *push(stack,item)
STACK	*stack;
char	*item;
{
	STACK	*new;
	
	if (!(new = (STACK *) malloc(sizeof(STACK))))
		error(DIE,"Cannot allocate %d bytes",sizeof(STACK));
	strncpy(new->as_mail,item,ADDRESSLEN);
	new->next = stack;
	error(DEBUG,"Added: \"%s\" to stack",item);
	return(new);
}

void str_append(s1,s2,max)
char	*s1, *s2;
int	max;
{
	if (max < 0) return;
	strncat(s1,s2,max-strlen(s1)-1);
}

void error(va_alist)
va_dcl
{
	va_list	args;
	int	grade;
	char	*fmt;
	
	va_start(args);
	grade = va_arg(args, int);
	fmt   = va_arg(args, char *);
	if (grade == DEBUG && !debug) {
		va_end(args);
		return;
	}
	fprintf(stderr,"%s%s: ",(grade==DEBUG)? "DEBUG: " : "",prog);
	vfprintf(stderr,fmt,args);
	fprintf(stderr,"\n");
	va_end(args);
	/* Do not exit on grade == 0 -- allows debug information */
	if (grade > 0) exit(grade-1);
}	
