# listserv
#
# 2-Mar-83 weber@eitech.com changed mv to cp, thanks to ysato@etl.go.jp
# 20-Nov-92 weber@eitech.com passed inputs variable for get command
# 19-Nov-92 weber@eitech.com restructured to handle multiple commands in body
# 19-Nov-92 weber@eitech.com added sensibility checks on (un)subscribe
# 18-Nov-92 weber@eitech.com added privacy check to recipients command
# 18-Nov-92 weber@eitech.com added get, which, release commands
# 25-Jun-92 weber@eitech.com updated to new parameter format
# 1-Jun-92 weber@eitech.com
#
# This service mimicks many of the commands in the listserv package
# for mailing list maintenance.  Mailing lists must be manually created;
# e.g., to create a list called "mylist", do a "touch ~/Lists/mylist" and
# then add the following line to your system's /etc/aliases file:
# "mylist: :include:~/Lists/mylist" (where you have to replace the "~"
# with services' home directory on your system).
#
proc listserv {switches envelope inputs} {
    if {$switches == ""} {
	set fid [open [getfield $inputs FILE] r]
	set needshelp 1
	while {[gets $fid switches] >= 0 && $switches != "--"} {
	    if {[llength $switches]} {
		set needshelp 0
		listservcommand $switches $envelope ""
	    }
	}
	close $fid
	if {$needshelp} {
	    listservcommand help $envelope ""
	}
    } {
        listservcommand $switches $envelope $inputs
    }
    return 0
}

proc listservcommand {switches envelope inputs} {
    cd ~/Lists
    set release "3.0"
    set mlist [string tolower [lindex $switches 1]]
    set person [getfield $envelope REPLYTO]
    set pattern [format "^%s" $person]
    case  [string tolower [lindex $switches 0]] {
	subscribe {
	    if {[file exists $mlist]} {
		if {[catch "exec grep -i -s $pattern $mlist"]} {
		    exec cp -p $mlist .$mlist
		    set fid [open $mlist a]
		    puts $fid [format "%s (%s)" $person [lrange $switches 2 end]]
		    close $fid
		    setfield response STRING "You are now on the $mlist mailing list."
		} {
		    setfield response STRING "You are already on the $mlist mailing list."
		}
	    } {
		setfield response STRING "Sorry, I don't maintain a $mlist mailing list."
	    }
	}
	{ unsubscribe signoff }  {
	    if {[file exists $mlist]} {
		if {[catch "exec grep -i -s $pattern $mlist"]} {
		    setfield response STRING "You were not on the $mlist mailing list."
		} {
		    exec cp -p $mlist .$mlist
		    catch "exec grep -v -i $pattern .$mlist > $mlist"
		    setfield response STRING \
		      "You have been removed from the $mlist mailing list."
		}
	    } {
		setfield response STRING "Sorry, I don't maintain a $mlist mailing list."
	    }
	}
	{ recipients review } {
	    if {[file exists $mlist]} {
		file stat $mlist stats
		if {$stats(mode) & 4} {
		    setfield response FILE $mlist
		} {
		    setfield response STRING \
			"Sorry, the $mlist mailing list is confidential."
		}
	    } {
		setfield response STRING \
		  "Sorry, I don't maintain a $mlist mailing list."
	    }
	}
	information {
	    if {[file exists $mlist.txt]} {
		setfield response FILE $mlist.txt
	    } {
		setfield response STRING \
		  "Sorry, I don't have information on the $mlist mailing list."
	    }
	}
	which {
	    catch "exec grep -l $pattern [glob {*}]" stuff
	    setfield response STRING $stuff
	    setfield response DESCRIPTION \
                 "ServiceMail mailing lists at [exec hostname] to which you belong"
	}
	get {
	    return [invoke-service archive-request [lindex $switches 2] \
				$envelope $inputs]
	}
	release {
	    setfield response STRING "This is ServiceMail listserv release $release."
	}
	lists {
	    setfield response STRING [glob {*}]
	    setfield response DESCRIPTION "ServiceMail mailing lists at [exec hostname]"
	}
	help {
	    setfield response FILE [glob ~/src/man/listserv.man]
	    setfield response DESCRIPTION "help regarding ServiceMail(tm) listserv"
	}
	default {
	    setfield response STRING \
	      "Sorry, I don't support the listserv command [lindex $switches 0]"
	}
    }
    return [mailout [turnaround $envelope] $response]
}
