/*Copyright (c)  1993 Enterprise Integration Technologies Corporation

Permission to use, copy, modify, distribute, and sell this software and
its documentation for any purpose is hereby granted without fee, provided
that (i) the above copyright notices and this permission notice appear in
all copies of the software and related documentation, and (ii) the name of
Enterprise Integration Technologies Corporation may not be used in any
advertising or publicity relating to the software without the specific,
prior written permission of Enterprise Integration Technologies Corporation.

THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.

IN NO EVENT SHALL ENTERPRISE INTEGRATION TECHNOLOGIES CORPORATION  BE
LIABLE FOR ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF
ANY KIND, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
PROFITS, WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY
THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
*/

#include "pdinq.h"

extern struct {
  string from;
  time_t date;
  string msgid;
} hdata;

extern struct list *firstel;

sendmaildata(buf)
  char *buf;
  {
    /*Get the data from the magic tag line that sendmail
      puts on the top of the message*/        
    char *sp;
    struct tm date;
    
    if(strncmp(buf,"From",4))
      goto fail;
  
    if(!(sp=strchr(buf+5,' ')))
      goto fail;

    *sp='\0';
    strcpy(hdata.from,buf+5);
    *sp=' ';

    strptime(sp+1,"%a %b %d %T %Y",&date);
    hdata.date=timelocal(&date);
    return(1);

    fail:
      error(E_SMTAG,buf);
      return(0);
  }

line2msgid(buf)
  char *buf;
  {
    strcpy(hdata.msgid,buf+11);
    trimsp(hdata.msgid);
  }

line2from(buf)
  char *buf;
  {
    char *begin;
    char *out,*tmp,*place,*end;
    
    if((*buf=='F')||(*buf=='f'))
      begin=buf+4;
    else
      begin=buf+8;
    if((!(tmp=(char *)malloc(strlen(begin))))||(!(out=(char *)malloc(strlen(begin)))))
    {
      error(E_NOMEM,NULL);
      return(0);
    }
    *out=0;    
    while((*begin!='\n')&&(*begin))
    {
      place=tmp;
      end=(gotill(begin,",;\n"));
      while(begin!=end)
        *place++=*begin++;

      begin++;
      *place='\0';
      canonicalize(tmp);
      sprintf(out+strlen(out),"%s",tmp);
      if((*begin!='\n')&&(*begin))
        strcat(out,"\t");
    }
    strcpy(hdata.from,out);
  }

canonicalize(addr)
  char *addr;
  {
    char *cur,*begin,*tmp;
    int quote,paren,esc,at;
    quote=paren=esc=at=0;

    trimsp(addr);
    begin=cur=addr;
    while(*cur)
    {
      if(esc)
      {
        esc=0;
        continue;
      }   
      if(quote)
      {
        if(*cur=='"')
        {
          quote=0;
          if((*++cur)=='@')
          {
            at=1;
            continue;
          }
          else
          {
            SETB(cur);
            continue;
	  }
        }
        if(*cur++=='\\')
          esc=1;
        continue;
      }
      switch(*cur)
      {
        case '"':
          quote=1;
          SETB(cur++);
          break;
        case ' ':
        case '\t':
          SETB(++cur);
          break;
        case '(':
          noparen(cur++);
          break;
        case '<':
          if(tmp=gotill(cur,">"))
          {
            cur=tmp;
            cur--;
            begin++;            
            goto doit;
          }
          cur++;
          break;
        case '@':
          at=1;
          cur++;
          break;
        default:
          cur++;
          break;
      }
    }

  doit:
      tmp=begin;
      while(tmp!=cur+1)
        *addr++=*tmp++;
      *addr='\0';  
      trimsp(addr);
      return(1);
  }    

char *gotill(begin,delim)
  char *begin,*delim;
  {
    char quote,paren,esc;
    quote=paren=esc=0;

      while(((!strchr(delim,*begin))||(quote||paren||esc))&&(*begin!='\0'))
      {
        begin++;
        if(esc)
        {
          esc=0;
          continue;
        }
        if(quote)
        {  
          quote^=(*begin=='"');
          continue;
        }
        switch(*begin)
        {
          case '(': paren++;
                    break;
          case ')': paren--;
                    break;
          case '"': quote=1;
                    break;
          case '\\': esc=1;
                    break;
        }                    
      }
      if(*begin=='\0')
        return((char *)NULL);
      return(begin);
  }    
    


noparen(start)
  char *start;
  {
    int paren,esc;
    char *foo=start;
    paren=esc=0;
    
    while((paren)&&(*foo))
    {
      if(esc)
      {
        esc=0;
        foo++;
        continue;
      }
      switch(*foo++)
      {
        case '(':
          if(!esc)
            paren++;
          break;
        case ')':
          if(!esc)
            paren--;
          break;
        case '\\':
          esc=1;
          break;
      }
    }
    while(*start++=*foo++);
  }
  
line2date(buf)
  char *buf;
  {
    char *dbegin=buf+5; /*Date:....*/
    char *tmp;
    time_t date;
    struct tm time;
    int pos;
    
    /*First crank up getdate() on this....*/
    if((date=getdate(dbegin,(struct timeb*)NULL))>0)
    {
      hdata.date=date;
      return;
    }

    /*Then check for the common sendmail style date....*/
    /*Getdate doesn't like a preceding DAY, so lop off everything
    to the first space*/
    tmp=dbegin;
    while(isspace(*++tmp));
    if(!(tmp=strchr(tmp,' ')))
      return;
    tmp++;
    if((date=getdate(tmp,(struct timeb*)NULL))>0)
    {
      hdata.date=date; 
      return;
    }
  }
    
trimsp(buf)
  char *buf;
  {
    char *foo;
    char *bar;

    foo=buf-1;
    while(trimmable(*(++foo)));
    bar=buf;
    while(*bar++=*foo++);
    
    bar=strlen(buf)+buf;
    while(trimmable(*(--bar)));
    *(bar+1)='\0';
  }

trimmable(a)
  char a;
  {
    if(isspace(a))
      return(1);
    return(0);
  }

usefrom(buf)
  char *buf;
  {
    static int replyto=0;

    if((!replyto)&&(!strncasecmp(buf,"From",4)))
      return(1);
    if(!strncasecmp(buf,"Reply-to",8))
    {
      replyto=1;
      return(1);
    }
    return(0);
  }

stashline(buf)
  char *buf;
  {
    static struct list *curel;
    struct list *new;
    
    new=(struct list *)malloc(sizeof(struct list));
    if(!new)
    {
      error(E_NOMEM,NULL);
      return(0);
    }
    
    if(!firstel)
      curel=firstel=new;
    else
    {
      curel->next=new;
      curel=new;
    }

    curel->next=0;
    if(!(curel->line=(char *)malloc(strlen(buf))))
    {
      error(E_NOMEM,NULL);
      return(0);
    }
    strcpy(curel->line,buf);
    return(1);
  }
     
    
      

