# archive-request
#
# 25-Jun-92 weber@eitech.com updated to new parameter format
# 29-May-92 weber@eitech.com
#
# Copyright (c)  1992 Enterprise Integration Technologies Corporation
#
# Permission to use, copy, modify, distribute, and sell this software and 
# its documentation for any purpose is hereby granted without fee, provided
# that (i) the above copyright notices and this permission notice appear in
# all copies of the software and related documentation, and (ii) the name of
# Enterprise Integration Technologies Corporation may not be used in any 
# advertising or publicity relating to the software without the specific, 
# prior written permission of Enterprise Integration Technologies Corporation.
# 
# THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
# EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
# WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
#
# IN NO EVENT SHALL ENTERPRISE INTEGRATION TECHNOLOGIES CORPORATION  BE
# LIABLE FOR ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF
# ANY KIND, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
# PROFITS, WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY
# THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
# PERFORMANCE OF THIS SOFTWARE.
#
# This service scans through a message body for postscript source, and
# sends what it found to the printer.  If the input is a multipart, it
# scans through the last body in the multipart.  It also does a check
# to see if the address is local (it won't print otherwise).
#
# This service retrieve files from an archive.  Patterns describing the desired
# files are in switches, or in the single body; all matching archive files are
# bundled into the output message
#

proc dofetch {switches envelope inputs} {
    if {[llength $switches] == 0} {
	set switches [exec cat [getfield $inputs FILE]]
	if {[llength $switches] == 0} {set switches "info.txt"}
    }
    cd ~/archive
    set hits {}
    foreach pattern $switches {
	  set foo [glob -nocomplain $pattern]
#Now we preprocess foo to make sure it doesn't have any verboten chars
          if {
               [string match /* $foo]||[string match ~* $foo]
               ||[string match ../* $foo]||[regexp /../ $foo]
               ||[string match  .\\./ $foo]||[regexp /.\\./ $foo]
          } then {
#Some sort of warning routine should go here...
          } else { set hits [concat $hits $foo]}
      
     }
    case [llength $hits] {
	0 { setfield response STRING "No files found in archive that match \"$switches\"." }
	1 {
	    setfield response FILE $hits;
	    setfield response DESCRIPTION "the archive file you requested"
	    setmimetype response
	}
	default {
	    setfield response TYPE multipart
	    setfield response SUBTYPE mixed
	    setfield response DESCRIPTION "the archive files you requested"
	    foreach hit $hits {
		set part {}
		setfield part FILE $hit
		setmimetype part
		lappend parts $part
	    }
	    setfield response PARTS $parts
	}
    }
    return [mailout [turnaround $envelope] $response]
}

proc setmimetype {objectname} {
    # set up filename as call-by-name
    upvar $objectname object
    set filename [getfield $object FILE]
    case $filename {
	*.ps { setfield object TYPE application; setfield object SUBTYPE postscript }
	*.tex { setfield object TYPE text; setfield object SUBTYPE x-latex }
	*.c { setfield object TYPE application; setfield object SUBTYPE x-c }
	*.sh { setfield object TYPE application; setfield object SUBTYPE x-sh }
	*.tar.Z { setfield object TYPE application
		  setfield object SUBTYPE octet-stream
		  setfield params name $filename
		  setfield params type tar
		  setfield params conversions compress
		  setfield object PARAMS $params
		}
	*.tar { setfield object TYPE application
		  setfield object SUBTYPE octet-stream
		  setfield params name $filename
		  setfield params type tar
		  setfield object PARAMS $params
		}
    }
}
