/*
 * $Header: /udir/vixie/src/mail11/d-1.7beta/RCS/vfformat.c,v 1.1 1991/09/02 23:58:25 vixie Exp vixie $
 */

#include <stdio.h>
#include <varargs.h>

/*
 * real simple version of printf that prints to a function.
 * understands %c, %d, %o, %x, %s, and %b (binary)
 */

static
dprint (d, b, func)
int d, b;
int (*func)();
{
   if (d == 0)
	return;
    dprint (d / b, b, func);
    (*func)("0123456789abcdef"[d % b]);
}


vfformat (func, format, arglist)
int (*func)();
char *format;
va_list arglist;
{
    char *carg;
    int darg;
    int base;

    while (*format) {
	if (*format == '%') {
	    ++format;
	    switch (*format) {
	    case 'c':
		darg = va_arg(arglist, int);
		(*func)(darg);
		break;
	    case 'd':
		base = 10;
		goto print;
	    case 'o':
		base = 8;
		goto print;
	    case 'x':
		base = 16;
		goto print;
	    case 'b':
		base = 2;
		goto print;
	    print:
		darg = va_arg(arglist, int);
		if (darg == 0)
		    (*func)('0');
		else
		    dprint (darg, base, func);
		break;
	    case 's':
		carg = va_arg(arglist, char *);
		if (carg == NULL)
		    carg = "(null)";
		while (*carg)
		    (*func)(*carg++);
		break;
	    case '%':
		(*func)('%');
		break;
	    }
	}
	else
	    (*func)(*format);
	++format;
    }
}
