/*
 * $Header: /udir/vixie/src/mail11/d-1.7beta/RCS/rfc822.c,v 1.1 1991/09/02 23:58:25 vixie Exp vixie $
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/timeb.h>

char *
RFC822_Today ()
{
    struct timeb t;
    char *ptr, *ctime ();
    struct tm *localtime ();
    static char timebuf[100];
    char *dayptr;
    char *format;

    ftime (&t);
    ptr = ctime(&t.time);
    /*
     * Hack to avoid two spaces in a row when day of month is one digit.
     * (either that or we could make the day of month "08" instead of " 8")
     */
    if (ptr[8] == ' ') {
	dayptr = &ptr[9];
	format = "%.3s, %.1s %.3s %.2s %.8s %s";
    }
    else {
	dayptr = &ptr[8];
	format = "%.3s, %.2s %.3s %.2s %.8s %s";
    }
    sprintf (timebuf, format,
	     &ptr[0],			/* day of week */
	     dayptr,			/* day of month */
	     &ptr[4],			/* month */
	     &ptr[22],			/* year */
	     &ptr[11],			/* hh:mm:ss */
	     timezone (t.timezone, localtime(&t)->tm_isdst));
    return timebuf;
}
