.\" Copyright (c) 1989 Keith Moore
.TH MAIL11D L "23 March 1989"
.SH NAME
mail11d \- server for incoming MAIL-11 messages
.SH DESCRIPTION
The 
.I mail11d
program is invoked whenever inbound MAIL-11 mail arrives from a remote
computer system running DECnet (e.g. a VAX/VMS system).  The program is
invoked automatically by the DECnet object spawner (on Ultrix), or
dnaserver (on SunOS) with standard input and output connected to a
DECnet socket.
.PP
.I mail11d
converts the incoming message from MAIL-11 format to RFC822 format.
In the process of the conversion, it attempts to convert sender and
recipient addresses into domain-style names.  The To:, X-To:, From:,
and Subject: headers are synthesized from the MAIL-11 envelope.
In addition,
.I mail11d
adds Received: and Date: headers based on the local system time of
arrival.
.PP
.I mail11d
establishes an SMTP connection with the local system mailer (usually
\fIsendmail\fR(8)), which it uses to verify addresses and to queue the
mail for delivery.
.PP
.I mail11d
currently implements the MAIL-11 protocol at about the level implemented
by early VMS version 4 systems.  It does, however, negotiate the use of
the Cc: field with the MAIL-11 client.

.SH CONFIGURATION
The following ncp configuration is appropriate for
.I mail11d
on DECnet-Ultrix systems:
.br
object name = mail11
.br
object number = 27
.br
file = \fI/usr/local/lib/mail11d\fR
.br
default user = daemon
.br
packet type = sequenced packet
.br
accept = deferred
.PP
The settings for "file" and "default user" may be modified to suit
local conventions.  These settings are similar to those required by
the \fImail11dv3\fR program supplied with DECnet-Ultrix version 3 or
later.

To install mail11d on SunOS systems running SunLink/DNI, put the line
.br
27 MAIL /usr/local/lib/mail11d
.br
in \fI/usr/sunlink/dna/dnaserver.reg\fR, then kill and restart
\fIdnaserver\fR.  On SunOS it may be advisable to make "dna" a
trusted user in the \fIsendmail\fR configuration file.

.SH ADDRESS TRANSLATION
In an attempt to be as compatible with as many RFC822 user agents as
possible,
.I mail11d 
translates sender addresses into a domain-style syntax.  For example,
mail from user \s-2JOE\s0 at node \s-2FOO\s0 will have a From: address of
\s-2JOE@FOO.DECnet\s0 instead of \s-2FOO::JOE\s0.  Complex DECnet
addresses or VMS MAIL foreign protocol addresses are quoted according
to RFC822 conventions, and to emphasize routing precedence.  For
instance:
.sp
.br
\s-2FOO::BAR::JOE\s0 becomes \s-2"BAR::JOE"@FOO.DECnet\s0, and
.br
\s-2FOO::BITNET%"USER@NODE"\s0 becomes \s-2"BITNET%\\"USER@NODE\\""@FOO.DECnet\s0
.PP
A site-specific suffix can be used instead of ".DECnet" by enclosing
.I mail11d
in an executable shell script which sets the environment variable
.B DECNET_DOMAIN_SUFFIX
to be the desired string.
In addition, if mail arrives from DECnet node
\s-2FOO\s0, and the environment variable 
.B FOO_DOMAIN
is set, the translated
variable is used as the domain instead of \s-2FOO.DECnet\s0.  This allows
primitive conversion of DECnet node names to Internet domain names.
.PP
Recipient addresses are translated as follows:
.br
Two consecutive double quotes ("") are converted to one double quote (").
.br
Single double quotes (") are stripped.
.br
Single quotes (') are converted to double quotes (").
.br
Backslash-d (\\d and \\D) is converted to a double quote (").
.br
Backslash-s (\\s and \\S) is converted to a single quote (').
.br
Single quotes and backslashes may be quoted by preceeding them with a
single backslash (\\).
.PP
Unfortunately, the MAIL-11 To: address cannot be reliably translated
into a legal RFC822 To: address, because the MAIL-11 To: address may
contain untranslated logical names that do not denote actual addresses
on the originating node.  Since RFC822 requires a valid recipient
header in all messages,
.I mail11d
constructs a To: line from the recipient list in the MAIL-11 envelope.

.SH FUTURE DIRECTIONS
.I mail11d
should eventually be able to perform smarter address translation on From:
addresses.  In particular, it should be able to shorten DECnet forwarding
paths if intermediate nodes are reachable.  Other transformations are
also possible and desirable, given the inability of vanilla sendmail to
perform inbound channel-specific rewrites.
.PP
Eventually,
.I mail11d
should be able to support block-mode transmission, and other more
recent additions to the MAIL-11 protocol.
.PP
It would be desirable for
.I mail11d
to recognize whether an incoming message already
contains RFC822 headers.  In this case
.I mail11d
would generate only Received:, Resent-to:, and Resent-From: headers
instead of the entire header set.
.PP
Ideally, 
.I mail11d
would attempt to determine whether any message recipients had mail forwarded
to DECnet, in which case the message would be sent immediately to
those recipients without going through \fIsendmail\fR and without
address translation or header processing.

.SH FILES
.I /usr/sunlink/dna/dnaserver.reg
(SunOS only)

.SH SEE ALSO
mail11(local), sendmail(8), ncp(8)
.br
\fISimple Mail Transfer Protocol\fR, RFC821
.br
\fIStandard for ARPA Internet Text Messages\fR, RFC822
.br
\fIDECnet-Ultrix User's and Programmers Guide\fR (Ultrix systems)
.br
\fISunLink DNI System Administration Guide\fR (SunOS systems)

.SH BUGS
Artifically constructed To: addresses can be very long.
.br
Lines longer than 512 characters cannot be transmitted, nor can
lines containing a single ASCII NUL.

.SH AUTHOR
Keith Moore, Computer Science Department, The University of Tennessee
at Knoxville
.br
\fI<moore@utkcs2.cs.utk.edu>\fR

.SH ACKNOWLEDGEMENTS
"DECnet", "Ultrix", "VAX", and "VMS" are trademarks of Digital
Equipment Corporation.
.br
"SunLink" is a trademark of Sun Microsystems, Inc.

.SH COPYRIGHT
Copyright \(co 1989, Keith Moore.
