#include "mail11.h"
/*
 * $Header: /udir/vixie/src/mail11/d-1.7beta/RCS/mail11.c,v 1.2 1991/09/23 01:32:21 vixie Exp $
 * Copyright 1989, Keith Moore
 */

/*
 * status codes to be sent to the remote mailer.  These are the constants
 * one and zero, respectively, in VAX byte order.
 */

char success_code[VAX_WORD_SIZE] = { '\1', '\0', '\0', '\0' };
char error_code[VAX_WORD_SIZE] = { '\0', '\0', '\0', '\0' };

/*
 * This pair of routines transfers the config information between a
 * struct mail11_config and a char buffer in a machine-independent
 * fashion.  This eliminates any byte order and/or structure member 
 * padding problems.
 */

void
GetConfigInfo (dest, src)
struct mail11_config *dest;
char *src;
{
    register unsigned long tmp;

    dest->protocol_version = *src++;
    dest->eco = *src++;
    dest->cust_eco = *src++;
    dest->os = *src++;
    tmp = (int)(*src++);
    tmp |= (int)(*src++) << 8;
    tmp |= (int)(*src++) << 16;
    tmp |= (int)(*src++) << 24;
    dest->options = tmp;
    tmp = (int)(*src++);
    tmp |= (int)(*src++) << 8;
    tmp |= (int)(*src++) << 16;
    tmp |= (int)(*src++) << 24;
    dest->iomode = tmp;
    dest->rfm = *src++;
    dest->rat = *src++;
}

void
PutConfigInfo (dest, src)
char *dest;
struct mail11_config *src;
{
    *dest++ = src->protocol_version;
    *dest++ = src->eco;
    *dest++ = src->cust_eco;
    *dest++ = src->os;
    *dest++ = src->options & 0xff;
    *dest++ = (src->options >> 8) & 0xff;
    *dest++ = (src->options >> 16) & 0xff;
    *dest++ = (src->options >> 24) & 0xff;
    *dest++ = src->iomode & 0xff;
    *dest++ = (src->iomode >> 8) & 0xff;
    *dest++ = (src->iomode >> 16) & 0xff;
    *dest++ = (src->iomode >> 24) & 0xff;
    *dest++ = src->rfm;
    *dest++ = src->rat;
    *dest++ = '\0';
    *dest++ = '\0';
}

void
PrintConfigInfo (str, ptr)
char *str;
struct mail11_config *ptr;
{
#ifdef DEBUG
    char *foo;
    DEBUG_Print ("%s\n", str);
    DEBUG_Print ("protocol version= %d\n", ptr->protocol_version);
    DEBUG_Print ("eco = %d, cust eco = %d\n", ptr->eco, ptr->cust_eco);
    DEBUG_Print ("os = %d", ptr->os);
    if (ptr->os == OS_VMS)
	DEBUG_Print (" VMS\n");
    else if (ptr->os == OS_ULTRIX)
	DEBUG_Print (" Ultrix\n");
    DEBUG_Print ("options = 0x%x", ptr->options);
    if (ptr->options & NOTIFYMSG)
	DEBUG_Print (" NOTIFYMSG");
    DEBUG_Print ("\n");
    DEBUG_Print ("iomode = 0x%x", ptr->iomode);
    if (ptr->iomode & BLKSEND)
	DEBUG_Print (" BLKSEND");
    if (ptr->iomode & BLKRECV)
	DEBUG_Print (" BLKRECV");
    if (ptr->iomode & PFXSEND)
	DEBUG_Print (" PFXSEND");
    if (ptr->iomode & PFXRECV)
	DEBUG_Print (" PFXRECV");
    if (ptr->iomode & CCSEND)
	DEBUG_Print (" CCSEND");
    if (ptr->iomode & CCRECV)
	DEBUG_Print (" CCRECV");
    DEBUG_Print ("\n");
    DEBUG_Print ("rfm = %d", ptr->rfm);
    switch (ptr->rfm) {
    case RFM_UDF:
	foo = "undefined";
	break;
    case RFM_FIX:
	foo = "fixed-length";
	break;
    case RFM_VAR:
	foo = "variable-length";
	break;
    case RFM_VFC:
	foo = "VFC";
	break;
    case RFM_STM:
	foo = "stream";
	break;
    case RFM_STMLF:
	foo = "stream-lf";
	break;
    case RFM_STMCR:
	foo = "stream-cr";
	break;
    default:
	foo = "unknown";
    }
    DEBUG_Print (" %s\n", foo);
    DEBUG_Print ("rat = 0x%x", ptr->rat);
    if (ptr->rat & RAT_FTN)
	DEBUG_Print (" FORTRAN");
    if (ptr->rat & RAT_CR)
	DEBUG_Print (" IMPLIED-CR");
    if (ptr->rat & RAT_PRN)
	DEBUG_Print (" PRN");
    if (ptr->rat & RAT_BLK)
	DEBUG_Print (" NOSPAN");
    DEBUG_Print ("\n");
#endif
}
