/*
 * $Header: /a1/vixie/src/mail11/d-1.7beta/RCS/debug.c,v 1.3 1991/09/26 00:56:08 vixie Exp $
 */

#include <stdio.h>
#include <varargs.h>
#include <sysexits.h>

static FILE *debug_file = (FILE *) NULL;

DEBUG_DumpBlock (label, block, length)
char *label;
register char *block;
register int length;
{
	register int i, j;

	if (!debug_file) return;

#define x(b) (isprint(b) || ((b) == ' ')) ? b : '.'
	fprintf (debug_file, "\"%s\" (%d-byte record):\n", label, length);
	for (i = 0; i < length; i += 16) {
	    fprintf (debug_file, "||| ");
	    for (j = i; j < i + 16 && j < length; ++j)
		fprintf (debug_file, "%02x%c", block[j], j == i + 7 ? '-' : ' ');
	    for (j = 16 - (j - i) + 1;  j > 0;  j--)
		fprintf (debug_file, "   ");
	    for (j = i; j < i + 16 && j < length; ++j) {
		fprintf (debug_file, "%c", x(block[j]));
		if (j == i + 7)
		    fprintf (debug_file, "-");
	    }
	    fprintf (debug_file, "\n");
        }
}

DEBUG_Open (file)
char *file;
{
    debug_file = fopen (file, "w");
    if (debug_file == (FILE *) NULL) {
	perror (file);
    }
    setlinebuf(debug_file);
}

DEBUG_Putc (c)
{
    if (debug_file)
	putc (c, debug_file);
}

DEBUG_Print (va_alist)
va_dcl
{
    va_list foo;
    char *format;
    
    if (debug_file == (FILE *) NULL)
	return;
    va_start (foo);
    format = va_arg (foo, char *);
    vfprintf (debug_file, format, foo);
    fflush (debug_file);
}

DEBUG_Close ()
{
    if (debug_file != NULL)
	fclose (debug_file);
    debug_file = (FILE *) NULL;
}

DEBUG_DoNothing ()
{
}
