/*
 * $Header: /udir/vixie/src/mail11/d-1.7beta/RCS/smtp.h,v 1.2 1991/09/23 01:41:05 vixie Exp $
 *
 * Definition module for functions that communicate with an SMTP server.
 *
 * All exported functions return a pointer to the smtp_reply structure,
 * which consists of a reply code and a possibly empty linked list of
 * message text.  Normally the reply code is obtained from the SMTP
 * server, but under exceptional conditions (server isn't responding)
 * the reply code is generated by the interface module.
 */

#include "defs.h"

struct smtp_reply {
    int code;
    struct text_msg msg;
};

/*
 * Open a connection to the SMTP server.
 */
struct smtp_reply *SMTP_Open ();
/*
 * Close the connection to the SMTP server.
 */
struct smtp_reply *SMTP_Close ();
/*
 * Send a command to the SMTP server and wait for the response.
 */
struct smtp_reply *SMTP_Command ();
/*
 * Write a line of text (i.e., message body) to the SMTP server.
 */
void SMTP_WriteLine P((char *, int));

#define SMTP_NULL 0			/* not opened */
#define SMTP_MAIL 1			/* waiting for MAIL command */
#define SMTP_RCPT 2			/* waiting for RCPT command */
#define SMTP_DATA 3			/* receiving DATA */
#define SMTP_ERR  4			/* not accepting data */
