/*
 * $Header: /udir/vixie/src/mail11/d-1.7beta/RCS/mail11.h,v 1.2 1991/09/23 01:41:05 vixie Exp $
 * 
 * configuration information passed when channel is opened.
 * the client sends his config info when opening the channel, and the
 * server (that's us) sends back its config info when accepting.
 */

#include "defs.h"

struct mail11_config {
    unsigned char protocol_version;
#define PROTOCOL_VERSION 3
    unsigned char eco;
#define ECO 0
    unsigned char cust_eco;
#define CUST_ECO 0
    unsigned char os;
#define OS_VMS 7			/* VAX/VMS */
#define OS_ULTRIX 18			/* Ultrix */
    unsigned long options;
#define NOTIFYMSG 01
    unsigned long iomode;
#define BLKSEND 01			/* client can send in block mode */
#define BLKRECV 02			/* server will expect block mode */
#define PFXSEND 04			/* client will prepend his node name */
#define PFXRECV 010			/* server won't prepend client node */
#define CCSEND  020			/* client can send Cc: line */
#define CCRECV  040			/* server will expect Cc: line */
    unsigned char rfm;
#define RFM_UDF 0			/* undefined */
#define RFM_FIX 1			/* fixed-length records */
#define RFM_VAR	2			/* variable-length records */
#define RFM_VFC 3			/* variable-length with fixed prefix */
#define RFM_STM 4			/* RMS-11 stream records */
#define RFM_STMLF 5			/* stream delimited by LF */
#define RFM_STMCR 6			/* stream delimited by CR */
    unsigned char rat;
#define RAT_FTN 01			/* fortran carraige control */
#define RAT_CR  02			/* printf ("\n%s\r", record) */
#define RAT_PRN 04			/* "print file" carraige control */
#define RAT_BLK 010			/* record can't cross block boundary */
};


/*
 * Success and error status codes, in VAX byte order.
 */

#define VAX_WORD_SIZE 4
extern char success_code[VAX_WORD_SIZE];
extern char error_code[VAX_WORD_SIZE];

void GetConfigInfo P((struct mail11_config *dest, char *src));
void PutConfigInfo P((char *dest, struct mail11_config *src));
void PrintConfigInfo P((char *str, struct mail11_config *ptr));
