.TH MAIL11 1 "11 January 1988"
.SH NAME
mail11 \- send mail to DECnet sites
.SH SYNOPSIS
.B mail11
[
.B -showconfig
]
.I sender-address
.I sender-name
.I destination-node
.I recipients...
.SH DESCRIPTION
.PN Mail11
is used to send mail to users on remote DECnet nodes.
It does not provide a user-friendly interface, and is actually designed
to be used by mail transfer agents such as 
.PN sendmail(1).
.PP
The command line arguments are not optional.  The sender-address should
be the last-resort reply-to address of the original sender.  Normally,
this will be argument of the SMTP MAIL FROM: line in the message envelope.
The 
.PN sendmail
$g macro works nicely here.
The sender-name should be the human-readable name of the sender.
Destination-node is the DECnet node name to which the mail will be
delivered, and the recipients are DECnet-style addresses of the 
recipients at that node.  Standard input should be an RFC822-formatted
mail message, which will be converted to MAIL-11 format before it is
sent to the destination DECnet node.
.PP
Since the mail-11 protocol only defines a single reply address,
.PN mail11
tries to figure out the best reply address from the message headers.
It chooses from the following, in order: Resent-Reply-To:, 
Resent-From:, Reply-To:, From:, Resent-Sender:,
Sender:, and finally the sender-address argument.  If a name
appears with the message header chosen, that name will also appear
in the MAIL-11 message header.

.PP
.PN Mail11
also examines the message headers for Resent-To:, To:, and Apparently-To: 
lines, and places the contents of the ``best'' of these in the MAIL-11 To: 
field.  Likewise, the Resent-Cc: and Cc: lines are examined as the source
for the MAIL-11 Cc: line, if supported by the remote MAIL-11 DECnet object.
The Subject: line, if present, is copied to the MAIL-11 Subj: line.

.SH OPTIONS
The
.PN -showconfig
option prints out configuration information that is exchanged between
.PN mail11
and the remote DECnet object.  This is used only for debugging.

.SH SENDMAIL CONFIGURATION
I use the following mailer description in
.PN sendmail(8)

MDmail, P=/usr/local/lib/mail11.utk, F=snF, S=17, R=27, A=mail11 $g $x $h $u

Rewrite rules should take into account that the DECnet node name of the gateway
system is prepended to the From: line by the remote DECnet node, so they should
take care to strip the local system name from sender addresses.

.SH FILES
/tmp/mail11*	temporary file for message headers

.SH "SEE ALSO"
mail(1), mm(l), mh(l), mailaddr(7), sendmail(8)

.SH DIAGNOSTICS
Exit status according to /usr/include/sysexits.h.

.SH BUGS
If the destination-node forwards mail to another DECnet node or to
another network, and an error occurs during delivery, the delivery
status will not be returned to
.PN mail11.
by the MAIL-11 object at the destination node.
The result is that sometimes mail will be returned to the sender
when the problem was in fact a temporary one (such as a link down),
or that sendmail will attempt to deliver the mail for several days
when in fact delivery is not possible.
.PP
Although
.PN mail11
can accept more than one recipient, it can only return a single error
code to the calling program.  Therefore if errors occur in delivery,
mail11 has no way of telling the calling program which recipients
received their mail successfully.
.PP
Lines consisting of a single NUL character cannot be transmitted with
the MAIL-11 protocol.  Such lines are changed to a single space.
