#!/import/tcl/bin/tclsh
# a program to much out the SMALLCAPS character format
# from H1 headers.

set in stdin
set out stdout

set para 0
set active 0
set smallcap 0
while {[gets $in line] >= 0} {
    switch -regexp -- $line {
	    { *<Para} {
		set para 1
	    }
	    { *<PgfTag `H1'>} {
		if {$para} {
		    set active 1
		}
	    }
	    { *> # end of Para} {
		set active 0
		set para 0
		set smallcap 0
	    }
	    { *<FTag `H1.smallcaps'>} {
		if {$active} {
		    set smallcap 1
		    continue
		}
	    }
	    { *<FTag `'>} {
		if {$active} {
		    set smallcap 0
		    continue
		}
	    }
	    { *<F.*} {
		if {$active} {
		    continue
		}
	    }
	    { *> # end of Font} {
		if {$active} {
		    continue
		}
	    }
	    { *<String.*} {
		if {$smallcap} {
		    if [regexp {( *<String `)([^']+)'>} $line x leader text] {
			puts $out "$leader[string tolower $text]'>"
		    } else {
			puts stderr "FAIL $line"
			exit
		    }
		    continue
		}
	    }

    }
    puts $out $line
}
