# Debug chapter
proc Debug { string } {
	global debug
	if ![info exists debug(enabled)] {
		# Default is to do nothing
		return
	}
	puts $debug(file) $string
}
proc DebugOn {{file {}}} {
	global debug
	set debug(enabled) 1
	if {[string length $file] == 0} {
		if [catch {open /tmp/debug.out w} fileID] {
			put stderr "Cannot open /tmp/debug.out"
			set debug(file) stderr
		} else {
			puts stderr "Debug info to /tmp/debug.out"
			set debug(file) $fileID
		}
	}
}
proc DebugOff {} {
	global debug
	if [info exists debug(enabled)] {
		unset debug(enabled)
		flush $debug(file)
		if {$debug(file) != "stderr" &&
			 $debug(file) != "stdout"} {
			close $debug(file)
			unset $debug(file)
		}
	}
}
