# Packer chapter
proc SetButtonSizes { frame {min 0} } {
	set maxl $min

	# Query each widget in the frame for its width.
	foreach w [pack slaves $frame] {
		set len [string length \
			[lindex [$w config -text] 4]]
		if {$len > $maxl} {
			set maxl $len
		}
	}
	# Set all the widths to be the same.
	foreach w [pack slaves $frame] {
		$w config -width $maxl
	}
	# Repack the widgets so they expand into any extra
	# space and fill that space with their display.
	# eval is used because pack slaves returns a list.
	eval pack [pack slaves $frame] -expand true -fill both
}
