# Xresource chapter
proc ButtonResources { f class } {
	frame $f -class $class -borderwidth 2
	pack $f -side top -fill x
	foreach b [option get $f buttonlist {}] {
		if [catch {button $f.$b}] {
			button $f.$b -font fixed
		}
		pack $f.$b -side right
	}
}
proc MenuResources { f class } {
    frame $f -class $class
    pack $f -side top
    set buttons {}
    foreach b [option get $f menulist {}] {
	    set cmd [list menubutton $f.$b -menu $f.$b.m \
					    -relief raised]
	    if [catch $cmd t] {
		    eval $cmd {-font fixed}
	    }
	    if [catch {menu $f.$b.m}] {
		    menu $f.$b.m -font fixed
	    }
	    pack $f.$b -side right
	    ButtonMenuInner $f.$b.m
	    lappend buttons $f.$b
    }
    eval {tk_menuBar $f} $buttons
}
proc ButtonMenuInner { menu } {
    puts stderr "ButtonMenuInner $menu"
	foreach e [option get $menu entrylist {}] {
	    puts stderr $e
		set l [option get $menu l_$e {}]
		set c [option get $menu c_$e {}]
		set v [option get $menu v_$e {}]
		switch -- [option get $menu t_$e {}] {
			check {
				$menu add checkbutton -label $l -command $c \
					-variable $v
			}
			radio {
				$menu add radiobuton -label $l -command $c \
					-variable $v
			}
			separator {
				$menu add separator
			}
			cascade {
				set sub [option get $menu m_$e {}]
				if {[string length $sub] != 0} {
					set submenu [menu $menu.$sub -tearoff 0]
					$menu add cascade -label $l -command $c \
						     -menu $submenu
					ButtonMenuInner $submenu
				}
			}
			default {
				$menu add command -label $l -command $c
			}
		}
	}
}
proc ResourceTest {} {
    catch {destroy .buttons .menubar}
    foreach file [glob -nocomplain *.resources] {
	option readfile $file startup
    }
    ButtonResources .buttons User
    MenuResources .menubar User
}
ResourceTest
