/*
**
** Copyright (C) 1994 Swedish University Network (SUNET)
**
**
** This program is developed by UDAC, Uppsala University by commission
** of the Swedish University Network (SUNET). 
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITTNESS FOR A PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
**
**                                        Martin.Wendel@udac.uu.se
**                                        Torbjorn.Wictorin@udac.uu.se
**
**                                        UDAC	
**                                        P.O. Box 174
**                                        S-751 04 Uppsala
**                                        Sweden
**
*/


#include "emil.h"

void	encode_mailtool(struct message *m)
{
  char buf[HDRLEN];
  if (m->level == 0)
    {
      if (match(m->type, "TEXT"))
	{
	  add_header(m, "Content-Type", "text", MAILTOOL);
	}
      else
	{
	  add_header(m, "Content-Type", "X-Sun-Attachment", MAILTOOL);
	  m->td->startbound = NEWSTR("----------");
	}
      if (m->td->length)
	{
	  sprintf(buf, "%i", m->td->length);
	  add_header(m, "Content-length", buf, MAILTOOL);
	}
      if (m->td->bodylines)
	{
	  sprintf(buf, "%i", m->td->bodylines);
	  add_header(m, "X-lines", buf, MAILTOOL); 
	}
    }
  else
    {
      if (m->td->encoding == EMULTI)
	{
	  m->td->startbound = NEWSTR("----------");
	  return;
	}
      if (match(m->type, "TEXT"))
	{
	  add_header(m, "X-Sun-Data-Type", "text", MAILTOOL);
	}
      else
      if (match(m->type, "APPLICATION"))
	{
	  add_header(m, "X-Sun-Data-Type", "default-app", MAILTOOL);
	}
      else
      if (match(m->type, "GIF"))
	{
	  add_header(m, "X-Sun-Data-Type", "gif-file", MAILTOOL);
	}
      else
      if (match(m->type, "ULAW"))
	{
	  add_header(m, "X-Sun-Data-Type", "audio-file", MAILTOOL);
	}
      else
	{
	  add_header(m, "X-Sun-Data-Type", "default", MAILTOOL);
	}
      if (m->description != NULL)
	add_header(m, "X-Sun-Data-description", m->description, MAILTOOL);
      else
	add_header(m, "X-Sun-Data-description", "default", MAILTOOL);
      
      if (m->name != NULL)
	add_header(m, "X-Sun-Data-name", m->name, MAILTOOL);

      sprintf(buf, "%i", m->td->lineend - m->td->linestart);
      add_header(m, "X-Sun-Content-lines", buf, MAILTOOL);

/*      sprintf(buf, "%i", m->td->length);
      add_header(m, "X-Sun-Content-length", buf, MAILTOOL); 
*/
    }
}

int decode_mailtool(struct message *m)
{
  if (m->level == 0)
    {
      if (matchheader(m, "Content-Type", "text", MAILTOOL))
	{
	  m->sd->format = MAILTOOL;
	  m->type = NEWSTR("TEXT");
	  m->sd->encoding = E7BIT;
	  m->sd->charset = (char *)gethval(m, "X-Sun-charset", MAILTOOL);
	}
      else
      /* Look for SUN Mailtool */
      if (matchheader(m, "Content-Type", "X-Sun-Attachment", MAILTOOL))
	    {
	      m->sd->format = MAILTOOL;
	      m->type = NEWSTR("MULTIPART");
	      m->sd->check = EMULTI;
	      m->sd->encoding = EMULTI;
	      m->sd->startbound = NEWSTR("----------");
	    }

      if (m->sd->format == MAILTOOL)
	{
	  m->sd->length = string2dec(gethval(m, "Content-length", MAILTOOL));
	  m->sd->bodylines = string2dec(gethval(m, "X-lines", MAILTOOL));
	  return(OK);
	}
      else
	return(NOK);
    }
  /**
   ** This is valid for SUN Mailtool message, except for root header 
   **/

  if (m->sd->format == MAILTOOL && m->level != 0)
    {
      /* Not complete or correct */
      if (matchheader(m, "X-Sun-Data-Type", "text", MAILTOOL))
	{
	  m->type = NEWSTR("TEXT");
	  m->sd->charset = "ISO-8859-1";
	  m->sd->encoding = E7BIT;
	}
      if (matchheader(m, "X-Sun-Encoding-Info", "uuencode", MAILTOOL))
	{
	  m->sd->encoding = EUUENCODE;
	}

	
      m->sd->length = string2dec(gethval(m, "X-Sun-Content-length", MAILTOOL));
      m->sd->bodylines = string2dec(gethval(m, "X-Sun-Content-lines", MAILTOOL));
      m->description = (char *)gethval(m, "X-Sun-Data-description", MAILTOOL);
      m->name = (char *)gethval(m, "X-Sun-Data-name", MAILTOOL);
    }  
  else
    return (NOK);
  return (OK);
}
