	/* getoption.c */

#pragma	alloca	/* For AIX */

#include	<assert.h>
#include	"emil.h"

#ifdef	HAVE_FNMATCH_H
#include	<fnmatch.h>
#else
static	int	ematch(char * pattern, char * string)
{
	/* Returns 0 if match, 1 else. '*' is a wildcard */

	for (;*pattern;pattern++)
	if (*pattern == '*') {
		while (*pattern=='*') pattern++;
		if (*pattern==0) return 0;
		while (*string) {
			if (ematch(pattern,string)==0) return 0;
			string++;
		}
		return	1;
	}
	else {
		if (*pattern != *(string++)) return 1;
	}
	return	* string;
}
#endif

static	int	line_count;
static	int	error_count;	/* used in lex */
static	int	should_load_config_file	= 1;
extern	FILE *	conf_fd;

void	* Yalloc(int siz)
{
	void	* Y;
	static	off_t	len	= 0,	/* Of allocated segment */
			offset	= 0,	/* Amount used thereof	*/
			pz;		/* Pagesize		*/
	static	char	* where;
        char ebuf[256];

	assert(siz > 0); siz     = ((siz + 3) / 4) * 4;	/* Word align */
	if ((len - offset) < siz) {

#ifdef	HAVE_GETPAGESIZE
		if (len==0)	len	= pz = getpagesize();
#elif	hpux
		if (len==0)     len	= pz	= 4096;
#else
		if (len==0)	len	= pz = sysconf(_SC_PAGESIZE);
#endif
		else		len	+= pz;
		if (len < siz)	len	= siz;
		/*
		 sprintf(ebuf,"Yalloc: len=%d offset=%d l-d=%d siz=%d",
			len, offset, len-offset, siz);
		 logger(LOG_DEBUG,ebuf);
		*/
		where	= malloc(len);
		if (where == NULL) {
			sprintf(ebuf,"getoption cannot get memory (%d) %m",len);
			logger(LOG_ERR,ebuf);
			exit(1);
		}
		Y	= where;
		offset	= siz;
	}
	else {
		Y	= &where[offset];
		offset	+= siz;
	}
	bzero(Y,siz);
	return	Y;
}

#define	N_CONTEXT_TYPES	3	/* Mime, UUencode, Applefile */

struct	member_struct	{
	struct	member_struct	* mm;	/* Points to next      */
	char	*	name;	/* Of the config group	       */
	char	*	r;	/* Receiver selection criteria */
	char	*	s;	/* Sender   selection criteria */
	char	*	rmx;	/* Receiver MX        criteria */
};

struct	lookup_struct {
	struct	lookup_struct	* ll;
	char	* matchstring;
	char	* out;
};

struct	lookup_struct	* table_start[N_CONTEXT_TYPES], 
			* table_end[N_CONTEXT_TYPES];

static	struct	config_struct	* g_start, /* Points to first group structure  */
				* g_end,   /* Points to the last group structure */	
				* gtmp;

static	struct	member_struct	* m_start, /* first member in chain */
				* m_end,   /* Last member in chain  */
				* mtmp;

static	char	* group_name;

static	int	Ycmp(char * pattern, char * string)
{
	char	p[255], s[255]; char	* c, *d; int i;
	int	cc;

	/* Copy / fold */

	for (c=pattern,d=p,i=(sizeof(p)-2); *c && i > 0; c++,d++,i--) *d = * c; *d = 0;
	for (c=string, d=s,i=(sizeof(s)-2); *c && i > 0; c++,d++,i--) *d = * c; *d = 0;

	/* Compare */

#ifdef	HAVE_FNMATCH_H
	cc = (fnmatch(pattern,string,0)==0);
#else
	cc = ematch(pattern,string);
#endif
	return	cc;
}

extern 	char	* yytext;	/* defined by flex */

/* static	int	yywrap()
	{
		return	1;
	}
*/

#define	yywrap()	1

static	void	yyerror(char * msg)
{
	char	ebuf[2048];
	sprintf(ebuf,"Config file: %s at line %d around '%s'\n",msg,line_count+1, yytext);
	logger(LOG_ERR,ebuf);
	error_count++;
}
typedef union
#ifdef __cplusplus
	YYSTYPE
#endif
 {
	char * string;
	int	val;
} YYSTYPE;
# define COLON 257
# define COMMA 258
# define EQUALS 259
# define CHARSET 260
# define TEXTENC 261
# define HENC 262
# define FORMAT 263
# define BIN 264
# define GROUP 265
# define MEMBER 266
# define EOR 267
# define MATCH 268
# define STRING 269
# define QSTRING 270

#ifdef __STDC__
#include <stdlib.h>
#include <string.h>
#else
#include <malloc.h>
#include <memory.h>
#endif

#include <values.h>

#ifdef __cplusplus

#ifndef yyerror
	void yyerror(const char *);
#endif

#ifndef yylex
#ifdef __EXTERN_C__
	extern "C" { int yylex(void); }
#else
	int yylex(void);
#endif
#endif
	int yyparse(void);

#endif
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern int yyerrflag;
YYSTYPE yylval;
YYSTYPE yyval;
typedef int yytabelem;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
#if YYMAXDEPTH > 0
int yy_yys[YYMAXDEPTH], *yys = yy_yys;
YYSTYPE yy_yyv[YYMAXDEPTH], *yyv = yy_yyv;
#else	/* user does initial allocation */
int *yys;
YYSTYPE *yyv;
#endif
static int yymaxdepth = YYMAXDEPTH;
# define YYERRCODE 256


#include	"lex.yy.c"

struct	config_struct *	getoption(char * r, char * s, char * rmx)
{
	struct	member_struct	* mm;
	struct	config_struct	* gg;

#ifdef	YYDEBUG
	extern	int	yydebug;
	yydebug	= 1;
#endif

	if (should_load_config_file) {
		should_load_config_file = 0;
		if ((yyin = conf_fd)          == NULL &&
		    (yyin = fopen(MAINCF,"r"))==NULL) {
			char	ebuf[512];
			strcpy(ebuf,"Cannot open '");
			strcat(ebuf,MAINCF);
			strcat(ebuf,"' ");
			logger(LOG_ALERT,ebuf);
			return NULL;
		}
		if (yyparse())	return	NULL;
		fclose(yyin);
	}

	/* Look for member */

	for (mm = m_start; mm; mm = mm->mm)		/* Lookup member */
		if (Ycmp(mm->r,r) && Ycmp(mm->s,s) && Ycmp(mm->rmx,rmx))
			for (gg = g_start; gg; gg = gg->gg) /* Lookup group */
				if (strcasecmp(gg->name,mm->name)==0) 
					return gg;
	return	NULL;	/* group or member not found */
}

static	void	confextr_error(char * txt, char * context, char * match, char * output)
{
	char	buf[255];
	strcpy(buf,txt);
	strcat(buf," confextr(\"");
	if (context) strcat(buf,context); else strcat(buf,"<NULL>");
	strcat(buf,"\", \"");
	if (match) strcat(buf,match); else strcat(buf,"<NULL>");
	strcat(buf,"\", \"");
	if (output) strcat(buf,output); else strcat(buf,"<NULL>");
	strcat(buf,"\")");
	yyerror(buf);
}

char	* confextr(char * context, char * match, char * output)
{
	int	context_type;
	struct	lookup_struct	* l;

	if (should_load_config_file) {
		should_load_config_file = 0;
		if ((yyin = conf_fd)          == NULL &&
		    (yyin = fopen(MAINCF,"r"))==NULL) {
			perror("cannot open config file");
			return NULL;
		}
		if (yyparse())	return	NULL;
		fclose(yyin);
	}

	if 	(context == NULL || 
		(match == NULL && output == NULL) ||
		(match != NULL && output != NULL))	{
		confextr_error("Confextr: Invalid parameter combination",
			context,match,output);
		return NULL;
	}

	if	(strcasecmp(context,"MIME")==0)		context_type	= 0;
	else if	(strcasecmp(context,"UUENCODE")==0)	context_type	= 1;
	else if	(strcasecmp(context,"APPLEFILE")==0)	context_type	= 2;
	else	{
		confextr_error("Confextr: invalid context", context, match, output);
		return NULL;
	}

	if (match == NULL) {
		if (output == NULL)	return NULL;
		for (l = table_start[context_type]; l; l = l->ll)
			if (strcasecmp(l->out,output)==0) return	l->matchstring;
		confextr_error("Confextr: invalid match", context, match, output);
		return	NULL;
	}
	else if (output == NULL) {
		if (match == NULL)	return NULL;
		for (l = table_start[context_type]; l; l = l->ll)
			if (strcasecmp(l->matchstring,match)==0) return	l->out;
		confextr_error("Confextr: invalid output", context, match, output);
		return	NULL;
	}
	else	{
		confextr_error("Confextr: both match & output set", context, match, output);
		return	NULL;
	}
}
yytabelem yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
	};
# define YYNPROD 18
# define YYLAST 69
yytabelem yyact[]={

    11,     3,     4,    43,     5,    10,    24,    41,    40,    39,
    38,    37,    35,    14,     8,     7,     6,    17,    20,    21,
    18,    19,    34,    26,    32,    25,    31,    30,    29,    28,
    27,    33,     9,    23,    15,    16,    22,    13,    12,     2,
     1,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,    36,     0,     0,     0,     0,     0,    42 };
yytabelem yypact[]={

-10000000,  -264,-10000000,  -253,  -254,  -255,  -225,  -252,  -270,-10000000,
-10000000,  -256,  -243,  -263,  -242,  -244,  -228,  -230,  -231,  -232,
  -233,  -235,  -236,-10000000,  -257,-10000000,-10000000,  -243,  -258,  -259,
  -260,  -261,  -262,-10000000,  -263,  -266,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000 };
yytabelem yypgo[]={

     0,    40,    39,    38,    34,    37,    36,    35,    33 };
yytabelem yyr1[]={

     0,     1,     1,     3,     2,     5,     2,     2,     4,     4,
     7,     7,     7,     7,     7,     6,     6,     8 };
yytabelem yyr2[]={

     0,     0,     4,     1,    12,     1,    12,    11,     2,     6,
     7,     7,     7,     7,     7,     2,     6,     7 };
yytabelem yychk[]={

-10000000,    -1,    -2,   265,   266,   268,   269,   269,   269,   257,
   257,   270,    -3,    -5,   269,    -4,    -7,   260,   263,   264,
   261,   262,    -6,    -8,   269,   267,   267,   258,   259,   259,
   259,   259,   259,   267,   258,   269,    -4,   269,   269,   269,
   269,   269,    -8,   269 };
yytabelem yydef[]={

     1,    -2,     2,     0,     0,     0,     0,     0,     0,     3,
     5,     0,     0,     0,     0,     0,     8,     0,     0,     0,
     0,     0,     0,    15,     0,     7,     4,     0,     0,     0,
     0,     0,     0,     6,     0,     0,     9,    10,    11,    12,
    13,    14,    16,    17 };
typedef struct
#ifdef __cplusplus
	yytoktype
#endif
{ char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

yytoktype yytoks[] =
{
	"COLON",	257,
	"COMMA",	258,
	"EQUALS",	259,
	"CHARSET",	260,
	"TEXTENC",	261,
	"HENC",	262,
	"FORMAT",	263,
	"BIN",	264,
	"GROUP",	265,
	"MEMBER",	266,
	"EOR",	267,
	"MATCH",	268,
	"STRING",	269,
	"QSTRING",	270,
	"-unknown-",	-1	/* ends search */
};

char * yyreds[] =
{
	"-no such reduction-",
	"expressions : /* empty */",
	"expressions : expressions expression",
	"expression : GROUP STRING COLON",
	"expression : GROUP STRING COLON varvals EOR",
	"expression : MEMBER STRING COLON",
	"expression : MEMBER STRING COLON users EOR",
	"expression : MATCH STRING QSTRING STRING EOR",
	"varvals : varval",
	"varvals : varval COMMA varvals",
	"varval : CHARSET EQUALS STRING",
	"varval : FORMAT EQUALS STRING",
	"varval : BIN EQUALS STRING",
	"varval : TEXTENC EQUALS STRING",
	"varval : HENC EQUALS STRING",
	"users : user_definition",
	"users : users COMMA user_definition",
	"user_definition : STRING STRING STRING",
};
#endif /* YYDEBUG */
/*
 * Copyright (c) 1993 by Sun Microsystems, Inc.
 */

#pragma ident	"@(#)yaccpar	6.12	93/06/07 SMI"

/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#define YYERROR		goto yyerrlab
#define YYACCEPT	return(0)
#define YYABORT		return(1)
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( "syntax error - cannot backup" );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#define YYNEW(type)	malloc(sizeof(type) * yynewmax)
#define YYCOPY(to, from, type) \
	(type *) memcpy(to, (char *) from, yynewmax * sizeof(type))
#define YYENLARGE( from, type) \
	(type *) realloc((char *) from, yynewmax * sizeof(type))
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG		(-10000000)

/*
** global variables used by the parser
*/
YYSTYPE *yypv;			/* top of value stack */
int *yyps;			/* top of state stack */

int yystate;			/* current state */
int yytmp;			/* extra var (lasts between blocks) */

int yynerrs;			/* number of errors */
int yyerrflag;			/* error recovery flag */
int yychar;			/* current input token number */



#ifdef YYNMBCHARS
#define YYLEX()		yycvtok(yylex())
/*
** yycvtok - return a token if i is a wchar_t value that exceeds 255.
**	If i<255, i itself is the token.  If i>255 but the neither 
**	of the 30th or 31st bit is on, i is already a token.
*/
#if defined(__STDC__) || defined(__cplusplus)
int yycvtok(int i)
#else
int yycvtok(i) int i;
#endif
{
	int first = 0;
	int last = YYNMBCHARS - 1;
	int mid;
	wchar_t j;

	if(i&0x60000000){/*Must convert to a token. */
		if( yymbchars[last].character < i ){
			return i;/*Giving up*/
		}
		while ((last>=first)&&(first>=0)) {/*Binary search loop*/
			mid = (first+last)/2;
			j = yymbchars[mid].character;
			if( j==i ){/*Found*/ 
				return yymbchars[mid].tvalue;
			}else if( j<i ){
				first = mid + 1;
			}else{
				last = mid -1;
			}
		}
		/*No entry in the table.*/
		return i;/* Giving up.*/
	}else{/* i is already a token. */
		return i;
	}
}
#else/*!YYNMBCHARS*/
#define YYLEX()		yylex()
#endif/*!YYNMBCHARS*/

/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
#if defined(__STDC__) || defined(__cplusplus)
int yyparse(void)
#else
int yyparse()
#endif
{
	register YYSTYPE *yypvt;	/* top of value stack for $vars */

#if defined(__cplusplus) || defined(lint)
/*
	hacks to please C++ and lint - goto's inside switch should never be
	executed; yypvt is set to 0 to avoid "used before set" warning.
*/
	static int __yaccpar_lint_hack__ = 0;
	switch (__yaccpar_lint_hack__)
	{
		case 1: goto yyerrlab;
		case 2: goto yynewstate;
	}
	yypvt = 0;
#endif

	/*
	** Initialize externals - yyparse may be called more than once
	*/
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

#if YYMAXDEPTH <= 0
	if (yymaxdepth <= 0)
	{
		if ((yymaxdepth = YYEXPAND(0)) <= 0)
		{
			yyerror("yacc initialization error");
			YYABORT;
		}
	}
#endif

	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */
	goto yystack;	/* moved from 6 lines above to here to please C++ */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yydebug )
		{
			register int yy_i;

			printf( "State %d, token ", yy_state );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_ps >= &yys[ yymaxdepth ] )	/* room on stack? */
		{
			/*
			** reallocate and recover.  Note that pointers
			** have to be reset, or bad things will happen
			*/
			int yyps_index = (yy_ps - yys);
			int yypv_index = (yy_pv - yyv);
			int yypvt_index = (yypvt - yyv);
			int yynewmax;
#ifdef YYEXPAND
			yynewmax = YYEXPAND(yymaxdepth);
#else
			yynewmax = 2 * yymaxdepth;	/* double table size */
			if (yymaxdepth == YYMAXDEPTH)	/* first time growth */
			{
				char *newyys = (char *)YYNEW(int);
				char *newyyv = (char *)YYNEW(YYSTYPE);
				if (newyys != 0 && newyyv != 0)
				{
					yys = YYCOPY(newyys, yys, int);
					yyv = YYCOPY(newyyv, yyv, YYSTYPE);
				}
				else
					yynewmax = 0;	/* failed */
			}
			else				/* not first time */
			{
				yys = YYENLARGE(yys, int);
				yyv = YYENLARGE(yyv, YYSTYPE);
				if (yys == 0 || yyv == 0)
					yynewmax = 0;	/* failed */
			}
#endif
			if (yynewmax <= yymaxdepth)	/* tables not expanded */
			{
				yyerror( "yacc stack overflow" );
				YYABORT;
			}
			yymaxdepth = yynewmax;

			yy_ps = yys + yyps_index;
			yy_pv = yyv + yypv_index;
			yypvt = yyv + yypvt_index;
		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yytmp = yychar < 0;
#endif
		if ( ( yychar < 0 ) && ( ( yychar = YYLEX() ) < 0 ) )
			yychar = 0;		/* reached EOF */
#if YYDEBUG
		if ( yydebug && yytmp )
		{
			register int yy_i;

			printf( "Received token " );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto yydefault;
		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--;
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
#if YYDEBUG
			yytmp = yychar < 0;
#endif
			if ( ( yychar < 0 ) && ( ( yychar = YYLEX() ) < 0 ) )
				yychar = 0;		/* reached EOF */
#if YYDEBUG
			if ( yydebug && yytmp )
			{
				register int yy_i;

				printf( "Received token " );
				if ( yychar == 0 )
					printf( "end-of-file\n" );
				else if ( yychar < 0 )
					printf( "-none-\n" );
				else
				{
					for ( yy_i = 0;
						yytoks[yy_i].t_val >= 0;
						yy_i++ )
					{
						if ( yytoks[yy_i].t_val
							== yychar )
						{
							break;
						}
					}
					printf( "%s\n", yytoks[yy_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
				yyerror( "syntax error" );
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
			skip_init:
				yynerrs++;
				/* FALLTHRU */
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yydebug )
						printf( _POP_, *yy_ps,
							yy_ps[-1] );
#	undef _POP_
#endif
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yydebug )
				{
					register int yy_i;

					printf( "Error recovery discards " );
					if ( yychar == 0 )
						printf( "token end-of-file\n" );
					else if ( yychar < 0 )
						printf( "token -none-\n" );
					else
					{
						for ( yy_i = 0;
							yytoks[yy_i].t_val >= 0;
							yy_i++ )
						{
							if ( yytoks[yy_i].t_val
								== yychar )
							{
								break;
							}
						}
						printf( "token %s\n",
							yytoks[yy_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yydebug )
			printf( "Reduce by (%d) \"%s\"\n",
				yy_n, yyreds[ yy_n ] );
#endif
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( yytmp )
	{
		
case 3:{
			/* this backward method is becase we want to look at first hit */
			gtmp	= g_end;
			g_end  	= Yalloc(sizeof(struct config_struct));
			if (g_start == NULL) 	g_start	= g_end;
			else			gtmp->gg= g_end;
			strcpy((g_end->name=Yalloc(strlen(yypvt[-1].string)+1)),yypvt[-1].string);
		  } break;
case 5:{
			strcpy((group_name=Yalloc(strlen(yypvt[-1].string)+1)),yypvt[-1].string);
		  } break;
case 7:{
			/* Add a entry to match table */
			int	ctyp;
			struct	lookup_struct	* ttmp, ** ts, ** te;
			if	(strcasecmp(yypvt[-3].string,"MIME")==0)	ctyp	= 0;
			else if	(strcasecmp(yypvt[-3].string,"UUENCODE")==0)	ctyp	= 1;
			else if	(strcasecmp(yypvt[-3].string,"APPLEFILE")==0)	ctyp	= 2;
			else	{
				yyerror("Wrong context type for match");
				YYERROR;
			}
			ts = &table_start[ctyp]; te = &table_end[ctyp];
			ttmp		= *te;
			*te		= Yalloc(sizeof(struct lookup_struct));
			if (*ts == NULL)  *ts	= *te;
			else		ttmp->ll= *te;
			strcpy(((*te)->matchstring=Yalloc(strlen(yypvt[-2].string)+1)),yypvt[-2].string);
			strcpy(((*te)->out=Yalloc(strlen(yypvt[-1].string)+1)),yypvt[-1].string);
		} break;
case 10:{
			strcpy((g_end->charset	= Yalloc(strlen(yypvt[-0].string)+1)),yypvt[-0].string);
		  } break;
case 11:{
			strcpy((g_end->format	= Yalloc(strlen(yypvt[-0].string)+1)),yypvt[-0].string);
		  } break;
case 12:{
			strcpy((g_end->bin	= Yalloc(strlen(yypvt[-0].string)+1)),yypvt[-0].string);
		  } break;
case 13:{
			strcpy((g_end->text	= Yalloc(strlen(yypvt[-0].string)+1)),yypvt[-0].string);
		  } break;
case 14:{
			strcpy((g_end->header	= Yalloc(strlen(yypvt[-0].string)+1)),yypvt[-0].string);
		  } break;
case 17:{
			mtmp	= m_end;
			m_end	= Yalloc(sizeof(struct	member_struct));
			if (m_start == NULL)	m_start	= m_end;
			else			mtmp->mm= m_end;
			m_end->name		= group_name;
			strcpy((m_end->r	= Yalloc(strlen(yypvt[-2].string)+1)),yypvt[-2].string);
			strcpy((m_end->s	= Yalloc(strlen(yypvt[-1].string)+1)),yypvt[-1].string);
			strcpy((m_end->rmx	= Yalloc(strlen(yypvt[-0].string)+1)),yypvt[-0].string);
		  } break;
	}
	goto yystack;		/* reset registers in driver code */
}

