# header.tcl
#
# This file is executed foreach chunk of headers encountered in
# the message. Beware formats like MIME which possibly contains
# several parts, each with a header of its own.
#
###############################################################
#
# These files will be sourced.
#
# Add any file that should be initially sourced into the SOURCES list.
#
set SOURCES {
init.tcl
mime.tcl
mnemonic.tcl
mailtool.tcl
sunet-spec.tcl
}

#
# Source 'em
#
foreach SOURCEFILE $SOURCES {
	debug "Sourcing $SOURCEFILE"
	if [file exists $appLibrary/headers/$SOURCEFILE] {
		source $appLibrary/headers/$SOURCEFILE
	} \
	else \
	{
		debug "Unable to source file $appLibrary/headers/$SOURCEFILE"
	}
	debug "$SOURCEFILE Done"
}

