/*
** Copyright (c) 1990,1991,1992 Keld Simonsen
** All rights reserved.
**
** Written by Keld Simonsen, RAP, Sct. Joergens Alle 8,
**            DK-1615 Copenhagen V, Denmark
**
** Redistribution and use of this routine in source and binary forms are
** permitted provided that:
**
** (1) source distributions retain this entire copyright notice. 
** (2) The character and character set codes and names may not be changed.
** (3) The programming code must remain backwards compatible.
**
** The restriction on altering of names is done so that all versons
** of the code have a chance of being compatible. If you want alterations
** or additions, please mail me (preferably email to  keld@dkuug.dk)
** and I will consider it for future releases.
** 
** If the material is included in commercial products, donations
** will be most appreciated.
** 
** Keld Simonsen
**
*/

/* -- The following 3 parameters may need modifying. --  */
typedef unsigned char	CHAR8U;	/* must be able to hold values 0-255 */
typedef short int	INT16S;	/* Must be able to hold 16 bits signed int */
typedef unsigned short int	CHAR16U;	/* Must be able to hold 16 bits unsigned int */
typedef long int	INT32S;	/* Must be able to hold 32 bits signed int */
#define DEFAULT_ESCAPE	8200	/* */

#define IN_CH		INT16S
#define OUT_CH		CHAR8U

#define C256L		256L
#define C256		256	/* max val of any char encoded as one byte */
#define LSIZE		256	/* max byte chars on a line, in a file name */

typedef struct chartab	CHARTAB;
struct chartab
begin
	CHARTAB		*next;
	INT32S		fileoffset;
	INT16S		ecma;
	INT32S		c0esc;  /* without leading ESC */
	INT32S		c1esc;
	INT32S		g0esc;
	INT32S		g1esc;
	INT32S		g2esc;
	INT32S		g3esc;
	INT16S		bits;
	INT16S		combtabs;
	INT16S		outbytes;
	INT16S		createout; /* create out from in */
	char		*name;
	IN_CH		*in;	/* characters in 2 byte mnemonic format */
	OUT_CH		*out;	/* characters in 8 bit format */
	CHAR16U		*out16;	/* characters in 16 bit format */
end;
typedef struct charset	CHARSET;
struct charset
begin
	CHARSET		*next;
	CHARTAB		*cs;
	INT32S		esc;
	CHAR8U		esc1;
	CHAR8U		esc2;
end;

struct chdbhdr
begin
	char label ARRAY(12);
	INT32S  version;
	INT32S  basechrs;	/* number of basic characters */
	INT32S  outsize;	/* size of OUT table */
	INT32S  begcombtabs;
	INT32S  offlong;	/* beginning of LONGNAMES table */
	INT32S  sizlong;	/* size of LONGNAMES table */
	INT32S  offchs;		/* beginning of CHARTAB tables */
	INT32S  sizchs;		/* size of CHARTAB tables */
	INT32S  offdat;		/* beginning of DIRECTORY index */
	INT32S  sizdat;		/* size of DIRECTORY index */
	INT32S  offdir;		/* beginning of DIRECTORY table */
	INT32S  sizdir;		/* size of DIRECTORY table */
	INT32S  offend;		/* end of tables */
end;

extern CHARSET *getchset();
#define syserr printf
#ifndef bzero
#define bzero(s, i)    memset(s, 0, i)
#endif
