
/*
 * Function prototypes 
*/
/* 7bit.c */
int     to_7bit(struct message *);
int     to_stripped(struct message *);
int     to_h7bit(struct hprs *);
int     to_hstripped(struct hprs *);

/* appledouble.c */
int     get_appledouble(struct message *);
int     put_appledouble(struct message *);

/* applefile.c */
int     fix_applefile(struct message *);
int     to_applefile(struct message *);
int     decode_double(struct message *);
int     decode_enc(struct message *);

/* applesingle.c */
int     get_applesingle_binary(struct message *);
char    *makelong(unsigned long, int);
int     put_applesingle(struct message *);
void    check_as_ad(struct message *);

/* a_attr.c */
int     check_apple_target(struct data *);

/* base64.c */
int     encode_base64(struct message *);
int     decode_base64(struct message *);

/* binary.c */
void    check_bits(struct data *);

/* binhex.c */
int     decode_binhex(struct message *);
int     encode_binhex(struct message *);

/* buffer.c */
void    safe_mchange(struct message *, struct data *);
void    free_data(struct data *);

/* charset.c */
int     tocharset(struct message *);
int     h_tocharset(struct hprs *);

/* convert.c */
int     convert_applefile(struct message *);
int	convert_data(struct message *);
int     recode_data(struct message *);

/* d_attr.c */
int     init_data(struct data *);
long    get_length(struct data *);
int     check_length(struct data *, long);
char    *get_string(struct data *, unsigned long, int);
void    set_type(struct data *);

/* filenames.c */
void    macify_filename(struct message *);
void    dosify_filename(struct message *);
void    unixify_filename(struct message *);
char    * getextension(char *);
void    fix_filename(struct message *);

/* forks.c */
void    do_fork();
int     end_fork();

/* formats.c */
void    encode_header(struct message *);
void    decode_header(struct message *);
char	* fixstring(char *, char *, char *, short);
int	matchheader(struct message *, char *, char *, int);
int     matchhvalue(struct header *, char *);
int     compare_header(struct hprs *, struct hprs *);
int     dmatch(struct data *, struct data *);
char 	* gethval(struct message *, char *, int);
int	string2dec(char *);
char	* stringpart(char *, char*, int);
int     matchpart(char *, char *, char *, int);
char	* getpartrest(char *, char *, char *);
int	match(char *, char *);
int     cmatch(char *, char *);

/* hbase64.c */
int     h_to_base64(struct hprs *);
int     h_from_base64(struct hprs *);

/* header.c */
int     load_header(struct message *);
void    clear_end(struct data *);
void    save_header(struct message *, struct data *, short, int);
void    add_header(struct message *, char *, char *, int);
void    rm_header(struct message *, char *);
int     isheader(char *);
char    *clear_end_space(char *);

/* hqp.c */
int     h_to_quoted_printable(struct hprs *);
int     h_from_quoted_printable(struct hprs *);

/* hqxbin.c */
unsigned long calc_crc(unsigned long crc, unsigned int);
int	get_binhex_crc(struct data *, unsigned long);
int	get_binhex_binary(struct message *);
int	create_binhex_binary(struct message *);

/* load.c */
struct data *load_data();
int	append_data(struct data *, char *, int, int);
int	append_char(struct data *, char, int);

/* logger.c */
void    logger(int, char *);
void    print_log();

/* mailtool.c */
void	encode_mailtool(struct message *);
int	decode_mailtool(struct message *);
int     get_body_lines(struct data *);

/* main.c */
int     main(int, char **);
void    fix_config_struct(struct config_struct *);

/* message.c */
int     parse_message(struct message *);
int     move_past_boundary(struct message *, char *);
int     check_header(struct message *);
int     check_encoding(struct message *);
int     boundary_check(struct message *);
int     is_bound(struct data *, char *);
struct message * copy_mstruct(struct message *, int);
int     getline(struct data *);
int     set_end_by_boundary(struct message *, char *);
int     set_end_by_lines(struct message *, int);

/* mime.c */
void	encode_mime(struct message *);
int	decode_mime(struct message *);
char    *getmimebound();

/* mimeparse.c */
int     parse_mime_message(struct message *);
int     parse_mime_multi(struct message *);
int     parse_mime_siblings(struct message *);

/* ns.c */
#ifdef NAMED_BIND
struct mxlist *get_mx(char *);
#endif

/* out.c */
void    out_message(struct message *);
void	print_body(struct data *);
int     print_line(char *);

/* qp.c */
int     encode_quoted_printable(struct message *);
int     decode_quoted_printable(struct message *);

/* rfc1522.c */
struct hprs *copy_hprs(struct hprs *);
int     where(char *, char);
int     parse_rfc1522(struct header *);
int     parse_hline(struct hprs *);
int     convert_hlines(struct hprs *);
int     recode_hline(struct hprs *);
int     h_tocharset(struct hprs *);

/* rfc822.c */
void    encode_rfc822(struct message *);
int     decode_rfc822(struct message *);
void    multipart_kludge(struct message *);

/* rfc822parse.c */
int     parse_rfc822_message(struct message *);

/* smtp.c */
void    make_connection(char *, FILE **, FILE **, int);
void    smtp_open(char *);
void    smtp_close(char *);
int     smtp_get();

/* structure.c */
struct message *fix_structure(struct message *);
struct message *split_into_messages(struct message *);
struct message *split_data_list(struct message *);
struct message *collapse_message(struct message *);
struct data *collapse_data(struct data *, struct data *, struct message *);
void   multimize(struct message *m, int);

/* sunparse.c */
int     parse_sun_message(struct message *);
int     parse_sun_multi(struct message *);
int     parse_sun_siblings(struct message *);

/* s_attr.c */
char    *makelong(unsigned long, int);
int     getlong(unsigned long *, struct data *);
unsigned long getblong(unsigned char *);
int     getshort(unsigned short *, struct data *);

/* uuencode.c */
int     decode_uuencode(struct message *);
int     encode_uuencode(struct message *);



/* getoption.y */
void    * Yalloc(int);		/* block, zero */
char    * confextr(char *, char *, char *);
char    **get_mailer(char *);
struct  config_struct   * getoption(char *, char *, char *);


