.TH EMIL 8 "19 December 1994"

.SH NAME

emil \- conversion filter for Internet messages

.SH SYNOPSIS

.B emil
.RB  "[\ " "-s"  
.IR  "Sender" "\ ]"
.RB  "[\ " "-r"
.IR  "Recipient" "\ ]"
.RB  "[\ " "-x"
.IR  "Recipient_host" "\ ]"
.RB  "[\ " "-l"
.IR  "Syslog_level" "\ ]"
.RB  "[\ " "-h" 
.IR  "Headerlog_level" "\ ]"
.RB  "[\ " "-f"
.IR  "Syslog_facility" "\ ]"
.RB  "[\ " "-i"
.IR  "Input_file" "\ ]"
.RB  "[\ " "-o"
.IR  "Output_file" "\ ]"
.RB  "[\ " "-m"
.IR  "Mailer" "\ ]"
.RB  "[\ " "-e"
.IR  "Configuration_file" "\ ]"
.RB  "[\ " "-c"
.IR  "Charsets_file" "\ ]"
.RB  "[\ " "-B"
.IR  "Recipient_bin_encoding" "\ ]"
.RB  "[\ " "-C"
.IR  "Recipient_charset" "\ ]"
.RB  "[\ " "-F"
.IR  "Recipient_format" "\ ]"
.RB  "[\ " "-H"
.IR  "Recipient_header_encoding" "\ ]"
.RB  "[\ " "-S"
.IR  "Sender_charset" "\ ]"
.RB  "[\ " "-T"
.IR  "Recipient_text_encoding" "\ ]"
.RB  "[\ " "-n" "\ ]"
.RB  "[\ " "-p" "\ ]"
.RB  "[\ " "-g" "\ ]"
.RB  "[\ " "-d" "\ ]"
.RB  "[\ " "-u" "\ ]"
.RB  "[\ " "-v" "\ ]"

.SH DESCRIPTION

The message conversion filter
.BR  emil
is used to convert the encoding of enclosures and character set of an Internet 
message aswell as between the three message formats MIME, SUN Mailtool 
and plain old style RFC822. Emil loads the message and applies
the changes in encoding and formatting in core. There is 
.BR no 
spooling. 

Emil can be applied by sendmail, if specified as a delviery agent, and can also
invoke sendmail or other programs for it's output. 
When used like this, emil does not close the connection with the calling 
sendmail until it returns an EX_OK from the called program, 
as a safety measure.

Emil can also be used by a mail client program or as a prefix to a delivery 
agent like binmail when acting like a regular filter. Usage is mainly
limited by your imagination.

Conversion is controlled either by the combination of 
.IR Sender,
.IR Recipient
and
.IR "Recipient_host"
as specified in the configuration file 
MAINCF
or as specified by the command line options.

.SH OPTIONS

.LP
Options may appear in any order.
.RS
.TP 
.BI "\-s " Sender
Sender's mail address.
.TP 
.BI "\-r " Recipient
Recipient's mail address.
.TP
.BI "\-x " Recipient_host
Name of the recipient host or relay.
.TP
.BI "\-f " Syslog_facility
Pick one of: m - LOG_MAIL, d - LOG_DAEMON, 0-7 LOG_LOCAL[0-7].
.TP
.BI "\-l " Syslog_level
Log level is set by specifying a number 1-4. Log level
becomes: 1 - LOG_ERR,
2 - LOG_NOTICE, 3 - LOG_INFO, 4 and more - LOG_DEBUG.
.TP
.BI "\-m " Mailer
Send output to the specified Mailer, where Mailer corresponds to 
a mailer definition in the configuration file emil.cf.
.TP

.BI "\-i " Input_file
Path to file for use as input. Defaults to standard input.
.TP
.BI "\-o " Output_file
Path to file for use as output. Defaults to standard output.
.TP
.BI "\-e " Configuration_file
Path to file for use as configuration file. Defaults to 
MAINCF
\.
.TP
.BI "\-c " Charsets_file
Path to file for use as charsets file. Defaults to 
CHARFILE

.RE
Beware, when applying any of the next five options, there is no
recipient look up in the configuration file.
.RS
.TP
.BI "\-B " Recipient_binary_encoding
Recipient binary encoding. One of BAse64, BInhex or Uuencode.
This defaults to nothing, thus no binary encoding conversion if
omitted unless gotten from the configuration file.
.TP
.BI "\-C " Recipient_charset
Recipient charset according to RFC1345. 
.TP
.BI "\-F " Recipient_format
Recipient format. One of MIME, MAILTOOL, RFC822 or TRANSPARENT. Defaults to
RFC822.
.TP
.BI "\-H " Recipient_header_encoding
Recipient header encoding. One of 7bit, 8bit, BAse64 or Quoted-printable.
See also emil.cf(8).
.TP
.BI "\-T " Recipient_text_encoding
Recipient text encoding. One of 7bit, 8bit, BAse64, BInhex, Quoted-printable
or Uuencode.

.RE
Beware, when applying the Sender_charset option, there is no
sender look up in the configuration file.
.RS
.TP
.BI "\-S " Sender_charset
Sender charset according to RFC1345.


.TP
.BI "\-h " Headerlog_level
Log in message header. This is for testing, not for production use.
Log level is specified by a number 1-4. Log level
becomes: 1 - LOG_ERR,
2 - LOG_NOTICE, 3 - LOG_INFO, 4 and more - LOG_DEBUG.

.TP
.BI "\-p "
Adds a pseudo route to sendmail when using the -f option. Instead
of calling sendmail with the recipient's address, call with
@EMIL:"recipient address". Used when sendmail is used to call
emil, to catch the visit to emil of the message.
.TP
.BI "\-g"
Test configuration file. Returns the matching group name based
on the provided recipient, sender and recipient host.
.TP

.BI "\-v"
Just prints version, then exits.
.TP

.BI "\-d"
Enables debugging on stderr. Using this will create voluminous output.
.TP

.BI "\-n"
Set up an SMTP connection to the host, as specified by the Recipient_host,
and send output on that connection. This makes Emil act as an SMTP-client,
and can be used as a replacement for the tcp mailer of sendmail.
.TP

.SH EXAMPLES

To use emil as a simple filter:
.RS

%cat message.in | emil [OPTIONS] > message.out

or

%emil [OPTIONS] -i message.in -o  message.out

.RE

See the other documentation for further information.

.SH FILES

.PD 0
.TP 20
MAINCF
configuration file.

.TP
CHARFILE
file containing the character set conversion tables.

.SH AUTHOR

Martin Wendel (Martin.Wendel@udac.uu.se) and
Torbjorn Wictorin (Torbjorn.Wictorin@udac.uu.se)

.SH "SEE ALSO"

emil.cf(8)

.SH BUGS

None?




