/*
 * os.h: getting the OS includes we need with the help of autoconf results
 *
 * Copyright(c) 1997,1998,1999 - All Rights Reserved
 *
 * See the COPYRIGHT file.
 */

#include "setup.h"

#if HAVE_STDIO_H
# include <stdio.h>
#endif

#if HAVE_STDLIB_H
# include <stdlib.h>
#endif

#if HAVE_UNISTD_H
# include <unistd.h>
#endif

#include <errno.h>

#include <ctype.h>
#include <assert.h>

#include <sys/ioctl.h>	/* used to be checked for by configure */
#include <sys/stat.h>
#include <fcntl.h>	/* for open() in term.c, and for server.c */
#include <sys/ioctl.h>	/* for ioctl() in term.c */
#include <termios.h>

#include <signal.h>

#ifdef HAVE_STRINGS_H
# include <strings.h>
#endif

#if STDC_HEADERS
# include <string.h>
#else
# ifndef HAVE_STRCHR
#  define strchr index
#  define strrchr rindex
# endif
          char *strchr (), *strrchr ();
# ifndef HAVE_MEMCPY
#  define memcpy(d, s, n) bcopy ((s), (d), (n))
#  define memmove(d, s, n) bcopy ((s), (d), (n))
# endif
#endif

#if TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif

#include <stdarg.h>

#include <sys/types.h>

#if defined(HAVE_SYS_SELECT_H)
# include <sys/select.h>
#endif

#if defined(UNSIGNED_LONG32) || defined(UNSIGNED_UNKNOWN32)
typedef	unsigned long	u_32int_t;
#endif
#ifdef UNSIGNED_INT32
typedef	unsigned int	u_32int_t;
#endif

#if defined(HAVE_REGEX_H) && !defined(USE_GNU_RX)
# define HAVE_REGEXP
# include <regex.h>
#endif

#if defined(USE_GNU_RX) && !defined(SDNS)
# include <rxposix.h>
# if !defined(rx_version_string)
    extern char rx_version_string[];
# endif
#endif

#if defined(__NetBSD__)
# define PUTS_ARG_TYPE (void (*)(int))
#else
# define PUTS_ARG_TYPE
#endif
