unit Game;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, StdCtrls, Menus,
     DdeMan;

type
  TFormD = class(TForm)

    MainMenu1: TMainMenu;
    File1: TMenuItem;
    NewLink1: TMenuItem;
    GroupBox2: TGroupBox;
    Button3: TButton;
    DdeClient: TDdeClientConv;
    DdeClientItem: TDdeClientItem;
    DdeServerItem1: TDdeServerItem;
    Edit3: TEdit;
    ListBox1: TListBox;
    Exit1: TMenuItem;
    procedure doPoke(Sender: TObject);
    procedure doPasteLink(Sender: TObject);
    procedure Edit1Click(Sender: TObject);
    procedure DdeServerItem1PokeData(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }

  end;

var
  FormD: TFormD;
  Service, Topic, Item : String;

implementation

uses Dialogs, SysUtils;

{$R *.DFM}

procedure TFormD.Edit1Click(Sender: TObject);
begin
  NewLink1.Enabled :=  GetPasteLinkInfo (Service, Topic, Item);
end;

procedure TFormD.doPasteLink(Sender: TObject);

begin
  if  GetPasteLinkInfo (Service, Topic, Item) then
  begin

    DdeClient.SetLink (Service, Topic);
    DdeClientItem.DdeConv := DdeClient;
    DdeClientItem.DdeItem := Item;
  end;
end;

procedure TFormD.doPoke (Sender: TObject);
var
  DdeCli : TDdeClientConv;
  s : String;
  TheData : array [0.. 1024] of char;
begin
  DDEServerItem1.CopyToClipboard;
  DdeCli := DdeClientItem.DdeConv;
  if DdeCli <> Nil then
    DdeCli.PokeData (DdeClientItem.DdeItem, StrPCopy(TheData, Edit3.text));
  ListBox1.items.add('>'+Edit3.text);
end;

procedure TFormD.DdeServerItem1PokeData(Sender: TObject);
begin
  Listbox1.items.add(DdeServerItem1.text);
end;

procedure TFormD.Exit1Click(Sender: TObject);
begin
     Close
end;

end.
