;;
;; format a nick!user@host string (user & host are optional)
;;
;; $Header: /home/fsf/friedman/src/zenirc/zenirc/scripts/RCS/zenirc-format-nickuserhost.el,v 1.1 1993/10/09 22:19:56 ben Exp mycroft $
;;
;; Despite the irc protocol spec, sometimes you get a string that is just
;; a hostname. To try to detect this, this routine just returns the hostname
;; if all it finds is a nick with no user and host information that contains 
;; a "." (which is not a legal character in a nickname). This will lose if a 
;; user chooses the same nickname as a server in the local domain that isn't 
;; using the FQDN. In this case, there is no way to tell if the message came 
;; from the user or the server.
;;

;;
;; set this to just "%s" for ircII-style display
;;
(defvar zenirc-user-format "%s!%s@%s"
  "*Format for nick, user, host data")

(defun zenirc-format-nickuserhost-hook (nickuserhost)
  (let (nick user host match1 match2)
    (setq nick (substring nickuserhost 0 (string-match "[!@]" nickuserhost)))
    (setq match1 (match-end 0))
    (if (string-match "!" nickuserhost)
	(progn
	  (setq user (substring nickuserhost match1 
				(string-match "@" nickuserhost match1)))
	  (setq match2 (match-end 0)))
      (setq user "")
      (setq match2 match1))
    (if (string-match "@" nickuserhost)
	(setq host (substring nickuserhost match2 (length nickuserhost)))
      (setq host ""))
    (if (and (string= user "") (string= host "") 
	     (string-match "\\." nick))
	;; "nick" is really a hostname if it has a . in it. This is a
	;; violation of the RFC spec for irc protocol, but servers do it
	;; anyway.
	(format "%s" nick)
      (format zenirc-user-format nick user host))))
