;;; zenirc-french.el --- French message catalog for ZenIRC

;; Copyright (C) 1993, 1994 Ben A. Mesander

;; Author: Nicolas Pioch <Nicolas.Pioch@enst.fr> (Nap)
;; Maintainer: Noah Friedman <friedman@prep.ai.mit.edu>
;; Keywords: extensions
;; Created: 1994/02/28

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this program; if not, you can either send email to this
;; program's maintainer or write to: The Free Software Foundation,
;; Inc.; 675 Massachusetts Avenue; Cambridge, MA 02139, USA.

;;; Commentary:

;; If you're using emacs 19, loading iso-ascii.el or doing
;; M-x standard-display-european on X displays makes 8-bit characters
;; easier to see.

;;; Code:

(require 'zenirc)

(zenirc-lang-define-catalog 'french
 '((join_you . "[info] Entre dans %s.\n")
   (join . "[info] %s entre dans %s.\n")
   (s001 . "[info] Vous perdez votre temps.\n") ; welcome to irc message
   ;; server name & version # msg
   (s002 . "[info] Votre serveur IRC est %s, version %s.\n")
   (s003 . "[info] Serveur cre %s.\n") ; when the server was built
   ;; # users on connect message
   (s251 . "[info] %s louzeurs visibles et %s invisibles sur %s serveurs.\n")
   (s252 . "[info] %s crtins sont en ligne.\n") ; irc operators msg
   (s253 . "[info] %s connexions non identifies.\n") ; unk connects msg
   (s254 . "[info] %s groupes.\n")      ; number of channels
   ;; # of clients and servers
   (s255 . "[info] %s clients et %s serveurs connects sur ce serveur.\n")
   (s301 . "[info] %s est absent: %s\n") ; someone is away
   (s302 . "[info] identification: %s.\n") ; userhost reply
   (s305 . "[info] Vous n'tes plus marqu absent.\n")
   (s306 . "[info] Vous tes marqu absent.\n")
   (s311 . "[info] %s (%s@%s) est %s\n") ; user part of /whois list
   (s312 . "[info] %s sur le serveur %s (%s)\n") ; server part of /whois list
   (s313 . "[info] %s est un crtin.\n") ; /whois operator status
   (s314 . "[info] %s (%s@%s) tait %s.\n") ; user part of /whowas list
   (s315 . "[info] Fin de /who.\n")     ; end of /who list replies
   (s318 . "[info] Fin de /whois.\n")   ; end of /whois list replies
   (s317 . "[info] %s a t inactif %s\n") ; /whois idle time
   (s319 . "[info] %s participe : %s\n") ; channel part of whois data
   (s321 . "[info] Groupes\tLouzeurs\tSujet\n") ; header for LIST cmd
   (s322 . "[info] %s\t%s\t%s\n")       ; each channel in LIST cmd
   (s323 . "[info] Fin de /list.\n")    ; trailer for LIST cmd
   (s324 . "[info] Mode de %s: %s %s.\n") ; channel mode
   (s331 . "[info] %s n'a pas de sujet.\n") ; no topic message
   (s332 . "[info] %s sujet: %s\n")     ; topic message
   (s341 . "[info] Vous invitez %s dans %s.\n") ; invite reply
   (s342 . "[info] Vous incitez %s  perdre son temps.\n") ; summon reply
   (s351 . "[info] Version: %s %s %s.\n") ; version reply
                                        ; header for /who list reply
   (s352_header . "[info] Pseudo  Etat Nom du Groupe  login et machine        Nom\n")
   (s352 . "[info] %-9s %-3s  %-15s %s@%s (%s)\n") ; /who list reply
   (s353 . "[info] Louzeurs sur %s: %s\n") ; displayed after channel join
   (s364 . "[info] %s %s %s\n")         ; /links reply
   (s365 . "[info] Fin de /links.\n")   ; end of /links reply
   (s367 . "[info] %s interdit  %s.\n") ; banlist reply
   (s368 . "[info] Fin de liste d'interdiction.\n") ; end of banlist reply
   (s371 . "[info] %s\n")               ; info reply
   (s372 . "[motd] %s\n")		; message of the day
   (s375 . "[motd] Message du jour:\n")	; start of motd
   (s376 . "[motd] Fin de message.\n")  ; displayed at end of motd
   (s381 . "[info] Vous etes maintenant un crtin total.\n") ; irc op status
   (s382 . "[info] Rechargement: %s\n") ; rehash server msg
   (s391 . "[info] Heure sur le serveur %s: %s.\n") ; TIME reply
   (s392 . "[info] Login Terminal  Machine\n") ; header for users rpl
   (s393 . "[info] %s\n")               ; body of users rpl
   (s395 . "[info] Personne n'est connect.\n") ; nobody for users rpl
   (s401 . "[info] Louzeur ou groupe inconnu: %s.\n") ; no such nick/chan
   (s402 . "[info] Serveur inconnu: %s.\n") ; there is no such server
   (s403 . "[info] Groupe inconnu: %s.\n") ; there is no such channel
   (s404 . "[info] Impossible d'crire  %s.\n") ; can't send to channel
   (s405 . "[info] Trop de groupes: %s.\n") ; too many channels
   (s406 . "[info] Le serveur ne se souvient plus de %s.\n")
   ;; user@host
   (s407 . "[info] Destinataires dupliqus, message non envoy: %s\n")
   (s411 . "[info] Destinataire manquant.\n") ; no recipient given
   (s412 . "[info] Texte manquant.\n")  ; you didn't send anything.
   (s413 . "[info] Domaine manquant: %s\n") ; no toplevel domain spec
   (s414 . "[info] Domaine invalide: %s.\n") ; wild toplevel
   (s421 . "[info] Charabia: %s.\n")
   (s422 . "[info] Certains crtins sont trop ignorants pour crer un mot de bienvenue.\n")
   (s423 . "[info] Les crtins de %s sont trop ignorants pour fournir les informations administratives.\n")
   (s431 . "[info] Pseudonyme manquant.\n") ; you didn't provide a nick
   (s432 . "[info] Pseudonyme invalide: %s.\n") ; invalid nick
   (s433 . "[info] Pseudonyme %s dja utilis.\n") ; invalid nick
   (s436 . "[info] Collision de pseudonymes: %s.\n") ; nickicide
   (s441 . "[info] %s n'est pas sur %s.\n") ; can't do it to those not present
   (s442 . "[info] Vous n'tes pas sur %s.\n") ; you can't do that dave.
   (s443 . "[info] %s est dj sur %s.\n") ; invite error
   (s444 . "[info] %s n'est pas connect.\n") ; SUMMON reply
   (s445 . "[info] Un quelconque crtin vous refuse l'usage de /summon.\n")
   ;; disabld users
   (s446 . "[info] Un quelconque crtin vous refuse l'usage de /users.\n")
   ;; gotta do the USER NICK thing
   (s451 . "[info] Vous n'tes pas encore enregistr.\n")
   (s461 . "[info] Paramtres insuffisants: %s\n") ; same as 421
   (s462 . "[info] Vous ne pouvez pas vous enregistrer  nouveau.\n")
   (s463 . "[info] Un quelconque crtin fasciste vous empche de vous connecter.\n")
   (s464 . "[info] Le mot de passe ne semble pas valable.\n") ; bad PASS command
   (s465 . "[info] Vous n'tes pas autoris  utiliser ce serveur.\n")
   ;; chan key set already
   (s467 . "[info] Il y a dj une cl sur %s.\n")
   (s471 . "[info] Impossible de rentrer sur %s (limite atteinte).\n")
   (s472 . "[info] Mode %s inconnu.\n") ; duh
   (s473 . "[info] Impossible de rentrer sur %s (sur invitation).\n")
   (s474 . "[info] Impossible de rentrer sur %s (interdit d'acces).\n")
   ;; bad key
   (s475 . "[info] Impossible de rentrer sur %s (cl invalide).\n")
   (s481 . "[info] Vous n'tes pas encore assez crtin pour cela.\n")
   ;; chanop needed
   (s482 . "[info] Vous n'tes pas assez puissant sur %s.\n")
   (s483 . "[info] Hep! Vous ne pouvez pas tuer un serveur.\n")
   (s491 . "[info] Pas de crtins connus sur votre site.\n") ; no o-line
   (s501 . "[info] Mode utilisateur inconnu.\n") ; you did something silly
   (s502 . "[info] Vous ne pouvez pas changer le mode de quelqu'un d'autre.\n")
   (ctcp_action . "[action->%s] %s %s\n") ; ctcp ACTION display
   (ctcp_clientinfo . "[interrogation] CLIENTINFO de %s sur %s.\n")
   (ctcp_errmsg . "[interrogation] ERRMSG de %s sur %s.\n")
   (ctcp_finger . "[interrogation] FINGER de %s sur %s.\n")
   (ctcp_ping . "[interrogation] PING de %s sur %s.\n")
   (ctcp_source . "[interrogation] SOURCE de %s sur %s.\n")
   (ctcp_time . "[interrogation] TIME de %s sur %s.\n")
   (ctcp_userinfo . "[interrogation] USERINFO de %s sur %s.\n")
   (ctcp_version . "[interrogation] VERSION de %s sur %s.\n")
   (debug . "[debug] %s\n")             ; displayed by debugging code
   (error . "[%s] %s\n")                ; server error message
   (invite . "[info] %s vous invite  perdre du temps sur %s.\n") ; invite
   (kick . "[info] %s a t ject de %s par %s.\n")
   (kick_you . "[info] Vous avez t ject de %s par %s.\n")
   (kill . "[info] Vous avez t tu: %s.") ; your time is up.
   (mode . "[info] %s a chang le mode sur %s: %s.\n") ; MODE change
   (nick . "[info] %s a chang de pseudo pour %s.\n") ; nick change
   (nosend . "[info] Pas de victime pour ce message.\n") ; msg not sent
   (notice . "{%s%s} %s\n")             ; NOTICE
   (notice_you . "{%s} %s\n")           ; NOTICE sent to your nick
   (now-querying . "[info] Victime: %s.\n") ; /query foo
   (part_you . "[info] Dpart de: %s (%s)\n") ; your part from channel message
   (part . "[info] %s quitte %s (%s)\n")    ;part from channel message
   (privmsg . "<%s%s> %s\n")            ; PRIVMSG
   (privmsg_you . "*%s* %s\n")          ; PRIVMSG sent to your nick
   (query . "[interrogation] de %s sur %s, contenu %s.\n") ; ctcp query
   (query_unknown . "commande CTCP inconnue.") ; we don't grok this
   (query_unbalanced . "[mauvaise interrogation] de %s vers %s, contenu %s.\n")
   (query_unbalanced_reply . "mauvaise rponse CTCP.") ; odd number of ^A's
   (quit . "[info] %s arrte de perdre du temps: %s\n") ; user signoff
   (reply . "[reponse] de %s sur %s, contenu %s.\n") ; ctcp reply
   (reply_unbalanced . "[mauvaise rponse] de %s sur %s, contenu %s.\n")
   (send . "(envoy sur %s)\n")      ; you sent a message/notice
   (send-action . "(envoy sur %s)")      ; you sent a message/notice
   (server . "[serveur] %s\n")          ; unknown server message
   (signal . "[signal dans %s]")        ; signal in echo area
   (topic . "[info] %s a chang le sujet sur %s pour: %s\n") ; topic message
   (wallops . "-%s- %s\n")              ; WALLOPS notice
   ))

(provide 'zenirc-french)

;;; zenirc-french.el ends here
