;;; zenirc-8ball.el --- magic 8 ball for ZenIRC

;; Copyright (C) 1996, Mark S Bailen
;; Copyright (C) 1996, Per Persson

;; Author: Mark S Bailen <moss@gnu.ai.mit.edu>
;;         Per Persson <pp@gnu.ai.mit.edu>
;; Maintainer: pp@gnu.ai.mit.edu
;; Keywords: zenirc, extensions, magic, 8ball
;; Created: 1996-10-4

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this program; if not, you can either send email to this
;; program's maintainer or write to: The Free Software Foundation,
;; Inc.; 675 Massachusetts Avenue; Cambridge, MA 02139, USA.

;;; Commentary:

;; code hacked from Noah's zenirc-yow.el and Eric's zenirc-random-away.el
;; 

;;; Code:

(require 'zenirc)

(defvar zenirc-8ball-mode t)
(make-variable-buffer-local 'zenirc-8ball-mode)

(random t)

(defvar zenirc-random-8ball-strings
  '("magic 8-ball says ====> REPLY HAZY, TRY AGAIN LATER "
    "magic 8-ball says ====> NO "
    "magic 8-ball says ====> YES "
    "magic 8-ball says ====> DEFINITELY NOT "
    "magic 8-ball says ====> MAYBE "
    "magic 8-ball says ====> CERTAINLY ")
  "*List of strings to use for 8 ball messages")

(defun zenirc-8ball-mode (&optional prefix)
  (interactive "P")
  (setq zenirc-8ball-mode (>= (prefix-numeric-value prefix) 0))
  (cond ((not (interactive-p)))
        (zenirc-8ball-mode
         (message "zenirc-8ball-mode is enabled"))
        (t
         (message "zenirc-8ball-mode is disabled")))
  zenirc-8ball-mode)


(defvar zenirc-8ball-regexp "\\b8 ball\\b"
  "*Regexp matching PRIVMSGs which deserve a random 8ball in response.")

(defvar zenirc-command-8ball-hook '(zenirc-command-8ball)
  "*Hook to call when a /8ball command is issued in ZenIRC.

The syntax of the command is: /8ball victim.
If no victim is specified, the current victim as specified by
zenirc-current-victim is used.")



(defun zenirc-server-PRIVMSG-8ball (proc parsedmsg)
  "Respond to 8 ball request.
The variable `zenirc-8ball-regexp' controls this."
  (if zenirc-8ball-mode
      (save-match-data
	(let ((case-fold-search t))
	  (cond ((and zenirc-8ball-regexp
		      (string-match zenirc-8ball-regexp (aref parsedmsg 3)))
		 (let* ((to (aref parsedmsg 2))
			(victim (cond
				 ((zenirc-names-equal-p to zenirc-nick)
				  (zenirc-extract-nick (aref parsedmsg 1)))
				 (t to)))
			(msg (nth (random (length zenirc-random-8ball-strings))
				  zenirc-random-8ball-strings)))
		   (zenirc-message proc '8ball-sent victim msg)
		   (process-send-string
		    proc (concat "PRIVMSG " victim " :" msg "\n")))))))))

(defun zenirc-command-8ball (proc victim)
  "Send an 8-ballquote to a specified victim.
See `zenirc-command-8ball-hook' for more information."
  (setq victim (cdr victim))
  (cond ((or (null victim)
             (string= "" victim))
         (setq victim zenirc-current-victim)))
  (let ((msg (nth (random (length zenirc-random-8ball-strings))
			     zenirc-random-8ball-strings)))
    (zenirc-message proc '8ball-sent victim msg)
    (process-send-string proc (concat "PRIVMSG " victim " :" msg "\n"))))


(provide 'zenirc-8ball)

(zenirc-lang-store-catalog-entry '8ball-sent "[info] Sent to %s: %s\n" 
				 'english)

(zenirc-add-hook 'zenirc-server-PRIVMSG-hook
                 'zenirc-server-PRIVMSG-8ball 'append)

;;; zenirc-8ball.el ends here
