(setq load-path (cons default-directory load-path))

(defun do-compile (name)
  (if (file-newer-than-file-p name (format "%sc" name))
      (progn
	(message "Compiling %s..." name)
	(byte-compile-file name))
    (message "Skipping file %s" name)))

(defun compile-w3 ()
  (do-compile (format "%sw3-emacs.el" default-directory))
  (do-compile (format "%sw3-emacs19.el" default-directory))
  (do-compile (format "%sw3-epoch.el" default-directory))
  (do-compile (format "%sw3-forms.el" default-directory))
  (do-compile (format "%sw3-gopher.el" default-directory))
  (do-compile (format "%sw3-html+.el" default-directory))
  (do-compile (format "%sw3-hyperbole.el" default-directory))
  (do-compile (format "%sw3-lists.el" default-directory))
  (do-compile (format "%sw3-lucid.el" default-directory))
  (do-compile (format "%sw3-mime.el" default-directory))
  (do-compile (format "%sw3-misc.el" default-directory))
  (do-compile (format "%sw3-mosaic.el" default-directory))
  (do-compile (format "%sw3-parse.el" default-directory))
  (do-compile (format "%sw3-print.el" default-directory))
  (do-compile (format "%sw3-url.el" default-directory))
  (do-compile (format "%sw3-vars.el" default-directory))
  (do-compile (format "%sw3.el" default-directory))
)

(compile-w3)

(condition-case ()
    (open-network-stream "testing" nil "cs.indiana.edu" 7)
  (error (progn
	   (message "Hey!  I can't resolve hostnames the way this emacs")
	   (message "(%s) was compiled.\n" (emacs-version))
	   (message "If you are using SunOS, try relinking with LIBS_SYSTEM")
	   (message "set to -lresolv in the ymakefile")
	   (message "\n")
	   (message "If you can't relink emacs, use the files tcp.c and")
	   (message "tcp.el in the extras tar file and specify the variable")
	   (message "tcp-program-name to point to the executable you get")
	   (message "after compiling tcp.c, and add the following line")
	   (message "To your .emacs file:")
	   (message
	    "   (autoload 'open-network-stream \"tcp\" \"Tcp emulation\" t)")
	   (message "\n-Bill Perry"))))

(condition-case ()
    (delete-process "testing")
  (error nil))

