/*
;; This file contains code of questionable quality.
;;
;; I accept no responsibility for damaged machines
;; accounts or egos.
;;
;; To the best of my knowlege, what is contianed here seems
;; to work for myself, and for my friends.
;;
;; All testing of this software so far was done with:
;;   berkely unix V  4.2A
;;   emacs        v  18.58.2
;;   gcc          v  2.1
;;
;; boring blurb dated: July 6th
*/
#include <stdio.h>
#include <sys/types.h>
#include <sys/param.h>
#include <syslog.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <errno.h>
#include <time.h>
#include "talk.h"
#include "zh.h"

struct sockaddr_in sin_dg;		/* this for global socket info */

void setup_host_info()
{
  int t;
  struct hostent *myhe;
  struct servent *sp;
  
  gethostname(myhost,32);	/* get the name of my node */
  
  if(myname)
    myusername = myname;	/*  */
  else
    myusername = getlogin();	/* what is my username */
  
  mypid      = getpid();	/* my pid  */

#ifdef DEBUG2  
  printf("%s, %s, %s, %d | %s, %s \n",hisusername,hishost,histty,command,
	 myusername,&myhost);
#endif
  
  myhe  = gethostbyname(myhost); /* get the hostent structure */
                                 /* type things  */
  
  /* 
   * set up my address structure
   */
  mya.sin_family = AF_INET;	/* set the family */
  mya.sin_port   = 0;
  bcopy(myhe->h_addr,(char *)&mya.sin_addr,myhe->h_length);
  bcopy(myhe->h_addr,(char *)&mydg.sin_addr,myhe->h_length);
  
  /* SOCKET THINGS */
  
  sindg.sin_family = AF_INET;
  sindg.sin_port = 0;
  sindg.sin_addr.s_addr = INADDR_ANY;
  
  if((sd = socket(AF_INET,SOCK_DGRAM,0)) < 0) 
    {
      perror("\03Socket for datagram failure.");
      exit(1);
    }
  if(bind(sd,(struct sockaddr*)&sindg, sizeof(sindg)) < 0) 
    {
      perror("\03bind for datagram failure.");
      exit(1);
    }
  
  t = sizeof(sindg);		/* how big is it */
  if(getsockname(sd, (struct sockaddr *)&sindg, &t) != 0) 
    {
      perror("\03getsockname");
      exit(1);
    }
  
  /* sin port already set */
  
  sindg.sin_family = htons(AF_INET);
  sindg.sin_addr = mya.sin_addr;
  
#ifdef DEBUG2
  printf("family:port -- %d, %d \n",sindg.sin_family,sindg.sin_port);
#endif
  
  if((sp = getservbyname("ntalk","udp")) == NULL) 
    {
      perror("\03error finding service");
      exit(1);
    }
  myhe = gethostbyname(hishost);
  
  if(myhe == NULL) 
    {
      printf("\03No such host %s!",hishost);
      exit(1);
    }
  
  hisdg.sin_family = mydg.sin_family = AF_INET;
  hisdg.sin_port   = mydg.sin_port = sp->s_port;
  bcopy(myhe->h_addr,(char *)&hisdg.sin_addr,myhe->h_length);
  
}

void ctl_transaction(struct in_addr target, msg_t type, int id_num,
		     CTL_RESPONSE *rp) 
{
  struct timeval      tv;
  int                 t, mask;
  struct sockaddr_in *sendaddr;
  static int          flag = 0;

  if(!flag) {
    setup_host_info();
    flag = 1;
  } else { 
#ifdef DEBUG2
    printf("Host info found already...\n");
#endif
    /* Ok, message things */
  }
    
  outm.vers     = TALK_VERSION;
  outm.type     = type;
  outm.id_num   = htonl(id_num);
  if(*(int *)&target)
    outm.addr   = *(struct sockaddr *)&ssaddr;
  else
    outm.addr   = *(struct sockaddr *)&sindg;
  outm.ctl_addr = *(struct sockaddr *)&sindg;
  outm.pid      = htonl(mypid);
  strcpy(outm.l_name,myusername);
  strcpy(outm.r_name,hisusername);
  strcpy(outm.r_tty,histty);
  
  if(type == LEAVE_INVITE || type == DELETE) 
    {
      sendaddr =  &mydg; 
    } else {
      sendaddr = &hisdg;
    }

#ifdef DEBUG2
  printf("---------------------------------------\n");

  fixprnt2(&outm);
#endif

  if(sendto(sd, (char *)&outm, sizeof (outm), 0, (struct sockaddr *)sendaddr, 
	    sizeof(struct sockaddr_in)) < 0) {
    perror("\03Sending datagram error");
    exit(1);
  }
  
  tv.tv_usec = 0;
  tv.tv_sec = 30;		/* 10 second timeout value. */
  do
    {
      mask = 1 | 1<<sd;		/* give mask 1 in ss position */
      if( (select(sd+1,(fd_set *)&mask,(fd_set *)NULL,(fd_set *)NULL,&tv) ) 
	 < 0)
	{
	  perror("\03Select during datagram to talk deamon:"); 
	  exit(1);
	}
      if(mask & (1<<sd))
	{  
	  if(recvfrom(sd, (char *)&inm, sizeof (inm), 0, 
		      (struct sockaddr *)sendaddr, 
		      &t) < 0) 
	    {
	      perror("\03Recveiving datagram error.");
	      exit(1);
	    }
	} else {
	  if(mask & 1) 
	    {
	      printf("\03No datagram received. Operation canceled by user.\n");
	      exit(1);
	    } else {
	      printf("\03Remote not responding. Resending.\n");
	      if(sendto(sd, (char *)&outm, sizeof (outm), 0, 
			(struct sockaddr *)sendaddr, 
			sizeof(struct sockaddr_in)) 
		 < 0) 
		{
		  perror("\03Sending datagram error");
		  exit(1);
		}
	      exit (0);
	    }
	}
    } while(!mask);

#ifdef DEBUG2
  fixprnt(&inm);
  printf("---------------------------------------\n");
#endif

}
