/*
;; This file contains code of questionable quality.
;;
;; I accept no responsibility for damaged machines
;; accounts or egos.
;;
;; To the best of my knowlege, what is contianed here seems
;; to work for myself, and for my friends.
;;
;; All testing of this software so far was done with:
;;   berkely unix V  4.2A
;;   emacs        v  18.58.2
;;   gcc          v  2.1
;;
;; boring blurb dated: July 6th
*/
/*
 * As far as I know, the predefinition of variables is not allowed in
 * cc as it is in gcc.  Therefore, I am assuming that this won't
 * compile under those cercumstances.  At the time, this C code was
 * not my top priority in this little project.  Hopefully by any real
 * release, I will have fixed these inconsistencies.
 */
#include <ctype.h>
#include <stdio.h>
#include <signal.h>
#include <sys/ioctl.h>
#include <sys/ttyio.h>
#include "talk.h"
#include "zh.h"

CTL_MSG        outm;		/* outbound message to server  */
CTL_RESPONSE   inm;		/* inbound message from server */

struct sockaddr_in     mya;	/* my address struct */
struct sockaddr_in     hisdg;	/* his address struct */
struct sockaddr_in     mydg;	/* his datagram address struct */
struct sockaddr_in     sindg;	/* socken address for datagram */

struct sockaddr_in     ssaddr;  /* My stream socket address */

struct sockaddr_in     hsaddr;  /* his stream socket address */

struct in_addr blah;		/* dunno */

int                    sd, ss,	/* socket dg port, and stream */
                       ts;      /* talk socket */
int            delid;		/* kept for deleting invites */
int            annid;		/* kept for deleting announces */

char           *myusername, *hisusername, *myname;
char            myhost[32], *hishost;
char           *mytty,      *histty;
int             mypid;
int             command;


struct hostent *me;

void am_server();
void am_client();
void go_do_some_talking();
void setmodes();
void restoremodes(int errcall);

char *editchars;

void main(int argc, char *argv[]) {
  
  if(argc > 5) 		/* convert the arguments */
    {
      histty      = argv[5];
    } else {
      histty      = "";
    }
  if(argc > 4) 
    {
      myname      = argv[4];
    } else {
      myname      = 0;
    }
  if(argc > 3) 
    {
      editchars   = argv[1];
      hisusername = argv[2];
      hishost     = argv[3];
    } else {
      printf("\03Not enough stuff for use...\n");
      exit(1);
    }

  
  /*  all "messages" to the emacs process start with ASCII 3 (ctrl-c) */
  /*  because that is one of the characters normal _talk_ can never */
  /*  send. :) */  

  printf("\03Looking for invite...\n");

  setmodes();  /* from zappomode.c */

               /* call ctl_transaction to send the command */

  bzero((char *)&blah,sizeof(blah));

  ctl_transaction(blah, LOOK_UP, -1, &inm); /* see if you are wanted */

               /* set stream socket reguardless of answer... */

  if( (ss = socket(AF_INET, SOCK_STREAM, 0)) < 0) 
    {
      perror("\03Can't allocate socket:"); 
      exit(1);
    }

  bzero((char *)&ssaddr,sizeof(ssaddr)); /* initialize */
  ssaddr.sin_family = AF_INET;

  if(inm.answer == 0)		/*  you are being called... setup  */
    {				/*  connection stuff from inm info */
      am_client();
    } else {			/* you have to try to call him... */
      am_server();
    }
  go_do_some_talking();
}

void am_server()
{
  struct timeval tv;
  int            num_announces = 1;
  int            mask = 0,t = sizeof(ssaddr);
  int            size = sizeof(hsaddr);
  struct in_addr blah3 = { 1 };

  ssaddr.sin_port   = 0;
  ssaddr.sin_addr.s_addr = INADDR_ANY;

  if( (bind(ss,(struct sockaddr *) &ssaddr, sizeof(ssaddr))) < 0) 
    {
      perror("\03bind failure: "); 
      exit(1);
    }
  t = sizeof(sindg);		/* how big is it */
  if(getsockname(ss, (struct sockaddr *)&ssaddr, &t) != 0) 
    {
      perror("\03getsockname failure:");
      exit(1);
    }
  ssaddr.sin_addr   = mya.sin_addr;
  ssaddr.sin_family = htons(AF_INET);

  ctl_transaction(blah3, ANNOUNCE, -1, &inm); /* send announce */

  if(inm.answer != SUCCESS) 
    {
      fprintf(stderr,"\03Announce failure.  User not logged in.\n");
      exit(0);
    }

  annid = ntohl(inm.id_num);	/* save announce id number */

  ctl_transaction(blah3, LEAVE_INVITE, -1, &inm); /* leave invitation */

  delid = ntohl(inm.id_num);	/* save invitation id number */

  if( (listen(ss,1)) < 0) 
    {
      perror("\03listen failure: "); 
      exit(1);
    }
  while(!mask) {
    printf("\03Ringing %s. [Try: %d].\n",hisusername, num_announces);
    num_announces++;
    mask = 1 | 1<<ss;		/* give mask 1 in ss position */

    tv.tv_usec = 0;
    tv.tv_sec = RING_WAIT;

    if( (select(ss+1,(fd_set *)&mask,(fd_set *)NULL,
	 	     (fd_set *)NULL,&tv) ) < 0)
      {
	perror("\03Selecting failure: "); 
	exit(1);
      }

    if(mask & 1) 		/* if something received from emacs, */
      {				/* IE, the user is impatient. */
	char blah2[10];
	
	read(1,blah2,10);
	
	ctl_transaction(blah, DELETE, delid, &inm); /* zap old invite */
	
	printf("\03Re-announcing.\n");
	ctl_transaction(blah3, ANNOUNCE, ++annid, &inm); 
	if(inm.answer != SUCCESS) 
	  {
	    fprintf(stderr,"\03Announce failure.  User logged out.");
	    exit(0);
	  }
	annid = ntohl(inm.id_num); /* zap old announce, save new one */
	
	ctl_transaction(blah3, LEAVE_INVITE, ++delid, &inm); 
	delid = ntohl(inm.id_num); /* save invitation */
	
	mask = 0;			/* set mask */
      } else {
	if(!mask) {		/* in this case nothing happened */
				/* except a timeout. */
	  ctl_transaction(blah3, ANNOUNCE, ++annid, &inm); 
	  if(inm.answer != SUCCESS) 
	    {
	      fprintf(stderr,"\03Announce failure.  User logged out.\n");
	      exit(0);
	    }
	  annid = ntohl(inm.id_num);
	  
	  ctl_transaction(blah3, LEAVE_INVITE, ++delid, &inm); 
	  delid = ntohl(inm.id_num);
	}
      }    
  }
				/* Cant leave loop unless port found */
				/* something. So accept the call. */
  printf("\03Accepting call...\n");
  if((ts = accept(ss, (struct sockaddr *)&hsaddr, &size)) < 0 ) 
    {
      perror("\03Accept failure: "); 
      exit(1);
    }
  ctl_transaction(blah, DELETE, delid, &inm); /* zap the old invite */
					      /* and announce */
  ctl_transaction(blah, DELETE, annid, &inm); 

  delid = annid = 0;
  
  printf("\03Connection established!!\n"); /* be happy */
}

void am_client()
{
  printf("\03Invite found.  Attempting to connect..\n");

  hsaddr = *(struct sockaddr_in *)&inm.addr;
  hsaddr.sin_family = ntohs(hsaddr.sin_family);
  ts = ss;			/* set the talk socket as my sock addr */

  if(connect(ts, (struct sockaddr *)&hsaddr, sizeof(hsaddr)) < 0) 
    {
      ctl_transaction(ssaddr.sin_addr, DELETE, ntohl(inm.id_num), &inm); 
      perror("\03Connect failure:"); 
      exit(1);
    }
  printf("\03Connection established!\n"); /* be happy. */
}

void go_do_some_talking()
{
  /* at this point:
   * ts - talk socket.
   */
  int            mask;		/* select mask on file descriptors */
  struct timeval tv;		/* time value used in delaying select */
  char           manychars[200]; /* buffer for input/output */
  char           hiseditchars[3]; /* his editing characters */
  int            i = 0;
  int            delayval = 5;	/* delay between select interupts */
  int            bighunks;	/* can i send many charaters, or only */
				/* a couple at a time. */


  write(ts,editchars,3);	/* send edit chars to opponent      */
				/* (received from argv[1])          */
  read(ts,hiseditchars,3);	/* get his edit chars               */
  write(1,hiseditchars,3);	/* tell the emacs process what they */
				/* are too. */
  if(strncmp(hiseditchars,editchars,3) == 0)
    bighunks = 1;		/* he is emacs and can do big hunks */
  else
    bighunks = 0;		/* is is weenie talk and cant handle */
				/* manly packets. */

  while(1) {
    mask = 1 | 1<<ts;		/* give mask 1 in ss position */
    tv.tv_usec = 0;
    tv.tv_sec = delayval;	/* timeout value. */

    if( (select(ts+1,(fd_set *)&mask,(fd_set *)NULL,
		     (fd_set *)NULL,&tv) ) < 0)
      {
	perror("\03Select error during chat:"); exit(1);
      }

    if(mask & 1) {		/* stdin */
      int j;
      
      if((i += read(1,(char *)(manychars+i),200-i)) <= 0) 
	{
	  perror("\03Error reading from stdin.  Emacs broken.");
	  exit(0);
	}

      if(bighunks) 
	{
	  if(write(ts,&manychars,i) <= 0)
	    {
	      perror("\03Write to host failed.  Disconnect.");
	      exit(0);
	    }
	} else {
	  for(j=0;j<i;j++)	/* make sure only one char is sent at */
				/* a time. */
	    if( write(ts,&manychars[j],1)  <= 0 ) 
	      {
		perror("\03Write to host failed. Disconnect.");
		exit(0);
	      }
	}
      i = 0;
    } else 
      if(mask & (1<<ts)) 
	{
	  int j;
	  
	  if((j = read(ts,manychars,200)) <= 0)
	    {
	      printf("\03Connection closed by peer.\n");
	      exit(0);
	    }
	  write(1,manychars,j);	/* write to stdout */
	} else {
	  if(!mask)		/* nothing happened! */
	    {
	      static int index1 = 0;

	      char *introstrings[] = {
		"Thank you for using emacs TALK...",
		"This talk program has been laborously crafted,",
		"In an attempt to stave off severe boredom at work.",
		"Report bugs to zappo@gnu.ai.mit.edu.",
		"","","",		/* pause */
		"Boring conversation eh?",
		"Try talking about sex... thats always interesting.",
		"Stimulating conversation.",
		"Impressive use of bandwidth resource.",
		"If silence were golden, you'd be a millionaire.",
		"tick tick tick tick tick tick.",
	      };

	      if(index1<(sizeof(introstrings)/sizeof(char *)))
		{
		  if(0) printf("\03%s\n",introstrings[index1++]);
		} else {
		  index1 = 5;
		  delayval += 3; /* make it slower */
		}
	      if(index1 == 4) delayval += 3;
	    }
	}
  }
}

/* procedure run when kill signal received. */
void onintr()
{
  fprintf(stderr,"\03Quit recieved. Stutdown.\n");
  /* \03 is ctrl-c.  signal to emacs process. */

  /* delete any announcements and invites that were set up but */
  /* interupted. */

  if(delid)
    ctl_transaction(blah, DELETE, delid, &inm); /* zap the old invite */
		                 		/* and announce */
  if(annid)
    ctl_transaction(blah, DELETE, annid, &inm); 

  close(sd);			/* datagram socket */
  close(ts);			/* talk socket */
  close(ss);			/* stream socket listening. */
  exit(0);
}

#define TRUE 1
#define FALSE 0

struct sgttyb ttys, ttysnew;	/* for stty terminal mode calls */
char *tty;			/* current tty name */

void setmodes()
{
  char *ttyname();
  
  int n;
  
  extern void onintr();
  
  sleep(2);			/* let any output appear */
  if (ioctl(0,TIOCGETP,&ttys)<0)  /* get tty params [V7] */ 
    {
      perror("\03Can't get TTY Parameters");
      exit(0);
    }
  
  tty = ttyname(0);  /* identify current tty */
  
  ttysnew.sg_ispeed = ttys.sg_ispeed;	/* copy input speed */
  ttysnew.sg_ospeed = ttys.sg_ospeed;	/* copy input speed */
  ttysnew.sg_flags |= RAW;	/* set for RAW Mode */
  ttysnew.sg_flags &= ~ECHO;	/* set for no echoing */
  ttysnew.sg_flags &= ~TANDEM;	/* turn off flow control */
  
  /* set new paramters */
  if (ioctl(0,TIOCSETP,&ttysnew) < 0) 
    {
      perror("\03Can't set new TTY Parameters");
      exit(0);
    }
  
  /* Flush characters waiting for read or write */

  n = 0;
  if (ioctl(0,TIOCFLUSH,&n) < 0) 
    {
      perror("\03Can't flush terminal queue.");
      exit(0);
    }
  
  /* set up signal catcher to restore tty state if we are KILLed */
  
  if (signal(SIGQUIT, SIG_IGN) != SIG_IGN)
    signal(SIGQUIT, onintr);
}

void restoremodes(int errcall)
{
  if (signal(SIGQUIT, SIG_IGN) != SIG_IGN)
    signal(SIGQUIT, SIG_DFL);
  return;
}



