;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 1, or (at your option)
;;; any later version.
;;;
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; The GNU General Public License is available by anonymouse ftp from
;;; prep.ai.mit.edu in pub/gnu/COPYING.  Alternately, you can write to
;;; the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
;;; USA.
;;; __________________________________________________________________________

;;;  show-function-prototypes.el - written by Glenn Coombs.

;;;  A function which will display a one line prototype of a C function in
;;;  the minibuffer area.  As writen it is designed for use with the
;;;  x-sb-mouse package by Sullivan Beck.  However it can easily be adapted
;;;  for keyboard-only use by removing the two lines as commented in the code.
;;;  It will then use the word the point is currently in when it is called.

(defvar proto-database "~/emacs/proto-database"
  "*The pathname of the database to use when looking up prototypes.")

(defun show-function-prototypes ()
  "Display prototype of function clicked on in the minibuffer."
  (interactive)
  (let ((old-pos (point))
		(old-window (selected-window)))
	(unwind-protect
		(let (word
			  match
			  begin
			  my-process
			  (exit-status 0)
			  (process-connection-type nil) ; use a pipe for communication
			  (database (expand-file-name proto-database))
			  (proto-buffer (get-buffer-create " *Prototypes*")))
		  (x-mouse-select)						; remove this line and
		  (save-excursion
			(goto-char x-mouse-point-d)			; this one for keyboard-only use.
			(skip-chars-backward "A-Za-z0-9_")
			(setq begin (point))
			(skip-chars-forward "A-Za-z0-9_")
			(setq word (buffer-substring begin (point))))
		  (setq match (concat " [*]*[ \t]*" word " ("))
		  (set-buffer proto-buffer)
		  (goto-char (point-min))
		  (if (re-search-forward match (point-max) t) 	; have we seen
			  (beginning-of-line) 						; this previously ?
			(setq my-process							; If not then grep for it.
				  (start-process "proto-process" proto-buffer "grep" match database))
			(set-process-sentinel my-process 'do-nothing)
			(while (equal 'run (process-status my-process))
			  (accept-process-output my-process))
			(setq exit-status (process-exit-status my-process))
			(if (/= 0 exit-status)
				(message "No prototype found for %s \(\)" word)
			  (goto-char (process-mark my-process))
			  (forward-line -1)))
		  (if (= 0 exit-status)
			  (progn
				(skip-chars-forward " \t")
				(setq match (buffer-substring (point) (progn (end-of-line) (point))))
				(message "%s" match))))
	(select-window old-window)
	(goto-char old-pos))))
