;;
;; PACKAGE: ange-ftp                     4.20               
;;

(setq ange-ftp-generate-anonymous-password t)
(defvar ange-ftp-process-startup-hook nil)
(setq ange-ftp-process-startup-hook
      (cons
       '(lambda () 
          (if (featurep 'fnexpand)
              (load-library  "fnexpand")))
       ange-ftp-process-startup-hook))
(require 'ange-ftp)



;;
;; PACKAGE: art-yow                     10/91               
;;

;; Use this database
;; (concat (getenv "LEMACSHOME") '"/lisp-ls6/datterich.yow")
;; (concat (getenv "HOME") '"/lisp/bush.yow")
(let ((yow-db (concat (getenv "LEMACSHOME") '"/lisp-ls6/datterich.yow")))
  (if (file-exists-p yow-db)
      (reset-yow-file yow-db)))
;;
;; Don't use quotes longer than this when using insert-n-line-yow
(setq max-yow-lines 10)
;;
;; Shortcut access to yow
(global-set-key "\C-xy"     
  	      (function (lambda () (interactive)(insert-string (yow)))))
(defun insert-quote ()
  (interactive)
  (cond ((equal last-command 'insert-quote)
         (delete-region (point) (mark)))
        (t
         (push-mark)))
    ;; (insert-string (yow))
    (goto-char (point-max))
    (insert "--\n")
    (let ((p (point)))
      (if (> max-yow-lines 0)
          (insert-n-line-yow max-yow-lines)
        (insert-string (yow)))
      (center-region p (point)))
    (insert-char 10 2))
;;
(global-set-key "\C-x\C-y"  'insert-quote)
;;
;; Add these lines to .emacs for mail signature with varying quotes:
;;
(if t                             ; Ok let's try
    (progn
      ;; You must have a ~/.signature file for this to be of use
      (defun mail-mode-hook-function ()
        (setq mail-send-add-signature t))
;;
      ;; Add signature and quote
      (defun mail-setup-hook-function ()
        (if mail-send-add-signature
  	  (save-excursion
  	    (goto-char (point-max))
  	    (insert-char 10 1)
  	    (set-mark (point))
              (insert "\\Ulrich Pfeifer\n")
  	    ;; (mail-signature)
              )))
      (setq mail-mode-hook (symbol-function 'mail-mode-hook-function))
      (defvar mail-setup-hook nil)
      (if (memq 'mail-setup-hook-function mail-setup-hook) ()
        (setq mail-setup-hook (cons 'mail-setup-hook-function
                                    mail-setup-hook)))
      ))				; if nil



;;
;; PACKAGE: auc-tex              5.4            
;;





;;
;; PACKAGE: auto-gc              Mon, 15 Mar 93               
;;





;;
;; PACKAGE: bal-wins 
;;





;;
;; PACKAGE: bbdb                 1.47; 11-sep-92.
;;

(setq bbdb-user-phone "3032")
(setq bbdb-user-home "Grotenbachstra\\3e 59	\\\\
 Dortmund 50")



;;
;; PACKAGE: bbdb-adr                 1.17
;;





;;
;; PACKAGE: bbdb-canonicalize                 1.2
;;





;;
;; PACKAGE: bbdb-letter             1.5           
;;

(setq bbdb-user-phone "3032")
(setq bbdb-user-home "Grotenbachstra\\3e 59	\\\\
 Dortmund 50")



;;
;; PACKAGE: bug-report                     1.4               
;;

(defvar mail-report-complain-by 
  "LS6 Symstemadministration <ls6support>")



;;
;; PACKAGE: c++-mode                     2.40              
;;

(if (featurep 'header) 
    (setq make-header-hooks
          (append 
           (cons '(lambda () 
                    (if (string-equal  header-prefix-string "// ")
                        (progn (setq header-prefix-string " * ")
                               (insert "/*\n"))))
                 make-header-hooks)
           (list '(lambda () (if (string-equal comment-start "// ")
                                 (insert " */\n")))))))
(defvar c++-mode-hook nil)
(if nil
    (progn
      (setq c++-mode-hook
            (cons '(lambda () 
                     (progn (setq comment-start "/* ")
                            (setq comment-end   " */")))
                  c++-mode-hook))
      ))
(setq c++-mode-hook 
      (cons 
       '(lambda () (local-set-key "%" 'match-paren))
       c++-mode-hook))



;;
;; PACKAGE: c-mode                                    
;;

(defvar c-mode-hook nil "")
(setq c-mode-hook 
      (cons 
       '(lambda () (local-set-key "%" 'match-paren))
       c-mode-hook))
(defun match-paren (arg)
  "Go to the matching parenthesis if on parenthesis otherwise insert %."
  (interactive "p")
  (cond ((looking-at "\\s\(") (forward-list 1) (backward-char 1))
        ((looking-at "\\s\)") (forward-char 1) (backward-list 1))
        (t (self-insert-command (or arg 1)))))
(setq  c-auto-newline nil)
(setq-default indent-tabs-mode nil)	; No TABs



;;
;; PACKAGE: c-style                     2.1             
;;





;;
;; PACKAGE: csh-mode                     
;;





;;
;; PACKAGE: cweb-mode                       July 1990             
;;





;;
;; PACKAGE: dired-adds                     1 Feb 90 22:35:33 GMT               
;;





;;
;; PACKAGE: EDB                  1.11           
;;





;;
;; PACKAGE: emerge               5 beta               
;;





;;
;; PACKAGE: env                     
;;





;;
;; PACKAGE: find-dired                     10/05/91               
;;





;;
;; PACKAGE: fnexpand                     ?              
;;

(require 'fnexpand)
;; shell
(defvar shell-mode-hook nil)
(setq shell-mode-hook
      (function (lambda () (local-set-key "\^I" 'complete-filename))))
;; mail
(defvar mail-setup-hook nil)
(setq mail-setup-hook  
            (cons 'mail-complete-filename  mail-setup-hook))
(defun mail-complete-filename ()
        (local-set-key "\C-j" 'complete-filename))



;;
;; PACKAGE: gnus                     3.14.1               
;;

(setq gnus-auto-select-first nil)



;;
;; PACKAGE: header                      2-Dec-1991              
;;

 (setq make-header-hooks
      '(
      ;;header-mode-line
      header-file-name
      header-copyright
      ;;header-sccs
      ;;header-AFS
      ;;header-ITI
      header-author
      header-creation-date
      header-modification-author
      header-modification-date
      header-update-count
      header-status
      ;; Re-enable the following lines if you wish
      ;;header-blank
      ;;header-history
      ;;header-purpose
      ;;header-toc
      header-rcs
      ))
(require 'header)



;;
;; PACKAGE: hippie-expand                                    
;;





;;
;; PACKAGE: hscroll 1992               
;;





;;
;; PACKAGE: HyperActiveFTP                     rs 22 Apr 92               
;;





;;
;; PACKAGE: Hyperbole                     3.06               
;;

(global-set-key "\M--" 
                '(lambda ()
                   (interactive)
                   (find-file '"~/.hyperb/Buttons")
                   (delete-other-windows)))
;;  (set-variable 'hbmap:dir-user "~/.hyperb/")
;;  (set-variable 'hbmap:dir-filename
;;                (concat (file-name-as-directory 
;;                         (expand-file-name hbmap:dir-user))
;;                        "HYPB")))



;;
;; PACKAGE: iso 1.7               
;;

(defun ISO-on ()
  "Turn on ISO-text-mode and do electric-accents."
  (interactive)
  (electric-accents)
  (ISO-text-mode)
  )

(defun ISO-off ()
  "Turn off ISO-text-mode and turn off electric-accents."
  (interactive)
  (electric-accents t)
  (ISO-text-mode t)
  (redraw-display))
(defvar text-mode-hook nil)
(autoload 'ISO-on "iso" "no comment here" t)
(autoload 'ISO-off "iso" "no comment here" t)
(global-set-key "\C-cE" 'ISO-on)
      



;;
;; PACKAGE: ISO-TeX                      Tue Aug 25 20:16:51 1992              
;;

(require 'ISO-tex)
(global-set-key "\C-x\C-i" 'toggle-ISO-TeX-mode)
(setq ISO-Tex-automatic-convert t)
(setq ISO-Tex-ask-for-confirmation nil)
(global-set-key "\C-cI" 'TeX-to-ISO)
(global-set-key "\C-cT" 'ISO-to-TeX)




;;
;; PACKAGE: ispell                     2.19               
;;

(defvar ispell-filter-hook "tr"
  "*Filter to pass a region through before sending it to ispell.
roduce output one word per line.  Typically this is set to tr,
, detex, etc.")
(make-variable-buffer-local 'ispell-filter-hook)
;;
(defvar ispell-filter-hook-args '("-cs" "A-Za-z" "\012")
  "*Argument LIST to pass to ispell-filter-hook")
(make-variable-buffer-local 'ispell-filter-hook-args)
;;
(defvar ispell-filter-hook-produces-single-column t
  "*This is nil if your ispell-filter-hook does not output one word per line.")



;;
;; PACKAGE: j-shell                     1.4               
;;

(setq jsh-prompt-pattern 
(concat 
 "\\(\\[" (user-login-name) "\@[a-z]+:[A-z0-9_./-]+\\]\\{[0-9]+\\} \\)"
 "\\|\\([a-z0-9]+\@[a-z]+ [0-9]+>\\)"
 ))
(setq jsh-history-stack-size 99)
(defun jsh (shell-number)
  "Just call j-shell"
  (interactive "p")
  (j-shell shell-number nil))
(autoload 'j-shell "j-shell" "" t nil)



;;
;; PACKAGE: kill-buffers                     1.1               
;;





;;
;; PACKAGE: latex-adds                     1.2               
;;





;;
;; PACKAGE: lib-complete                     1.7               
;;





;;
;; PACKAGE: lispdir                     4               
;;





;;
;; PACKAGE: lwf May 2, 1989               
;;





;;
;; PACKAGE: mail                     Dist 18.58               
;;

(defvar mail-setup-hook nil)
;;
(defun mail-insert-self-blind()
  (interactive)
  (save-excursion
    (beginning-of-buffer)
    (re-search-forward "^Subject:")
    (beginning-of-line)
    (insert "BCC: pfeifer\n")))
;;
(setq mail-setup-hook
      (cons '(lambda () (local-set-key "\C-c\C-b" 'mail-insert-self-blind))
            mail-setup-hook))
;;
(setq mail-setup-hook (cons 'bbdb-insinuate-sendmail mail-setup-hook))
;;
(setq mail-default-reply-to 
      "Ulrich Pfeifer <pfeifer@ls6.informatik.uni-dortmund.de>") 
;;
;;(setq mail-setup-hook (cons 'mail-ask-for-cc mail-setup-hook))
;;
;; Add X-face
(defvar mail-send-add-xface t)
(defun mail-setup-add-xface-function ()
  (if mail-send-add-xface
      (save-excursion
        (end-of-buffer)
        (re-search-backward mail-header-separator)
        (insert "X-Face:")
        (let ((face-file (expand-file-name "~/.face")))
          (if (file-exists-p face-file)
              (progn
                (insert-file (expand-file-name "~/.face"))
                (exchange-dot-and-mark)
                (insert "X-Planation: X-Face can be viewed with "
                        "\"faces\" or \"xmail\" (X11R5 contrib tape).\n")))))))
;;
;; Hooks
(if (memq  'mail-setup-add-xface-function mail-setup-hook) ()
  (setq mail-setup-hook (cons 'mail-setup-add-xface-function
                              mail-setup-hook)))
;;
;; complete-filename in mail mode
;;
(if (featurep 'fnexpand)
    (progn
      (defvar mail-setup-hook nil)
;;
      (setq mail-setup-hook  
            (cons 'mail-complete-filename  mail-setup-hook))
;;
      (defun mail-complete-filename ()
        (local-set-key "\C-j" 'complete-filename))))



;;
;; PACKAGE: makefile-adds                     1.2                
;;

(global-set-funkey "192z" 'Makefile-center-assignment)
(global-set-funkey "499z" 'Imakefile-rule-add-eoln)



;;
;; PACKAGE: math                     89/05/24       
;;

(setq math-mode-hook
      (function (lambda ()
                  ;;(setq math-show-debug t)
                  (define-key math-mode-map "\C-c\C-g" 'math-group-region)
                  ;; more key bindings or other variable settings
                  )))



;;
;; PACKAGE: minibuf 12/13/89
;;





;;
;; PACKAGE: MISC                     *-*               
;;

;;
;; Utils
;;
(defun delete-visited-file ()
  (interactive)
  (let ((filename (buffer-file-name)))
    (if filename 
        (progn 
          (delete-file filename)
          (kill-buffer (current-buffer))
          (message "File '%s' removed" filename))
      (message "no associated buffer"))))

(global-set-key "\C-x\C-k\C-k" 'delete-visited-file)

(defun startup-message ()
  (switch-to-buffer "*scratch*")
  (end-of-buffer)
  (insert-file-contents "/etc/motd")
  (not-modified)
  (sit-for 30)
  (delete-region (point) (point-max))
  (not-modified))

;;
;; Added by emacs
;;
(put 'narrow-to-page 'disabled nil)
(put 'narrow-to-region 'disabled nil)




;;
;; PACKAGE: multishell                     91-07-22               
;;





;;
;; PACKAGE: myisearch 
;;

(fmakunbound 'isearch)
(autoload 'isearch "myisearch") 



;;
;; PACKAGE: par-align            28-Apr-89      
;;

(require 'par-align)



;;
;; PACKAGE: proto                     
;;





;;
;; PACKAGE: rcs                     Revision: 1.67               
;;





;;
;; PACKAGE: rmail                     Dist 18.58               
;;

(defun my-rmail-reply (to-all-recipients)
  "Reply to the current message.
Normally not include CC: to sender of original message;
prefix argument means to all other recipients.
While composing the reply, use M-x mail-yank-original to yank the
original message into it."
  (interactive "P")
  (rmail-reply (not to-all-recipients)))
;;
(defvar rmail-mode-hook nil)
(setq rmail-mode-hook 
      (cons '(lambda () (local-set-key "r" 'my-rmail-reply))
            rmail-mode-hook))



;;
;; PACKAGE: roget 
;;





;;
;; PACKAGE: saveconf            Norma Jean               
;;

(set-variable 'auto-save-and-recover-context t)
(set-variable 'save-buffer-context t)	; save all buffers
(require 'saveconf)




;;
;; PACKAGE: sccs                     v2.0 March 4 1990
;;

(setq sccs-default-bindings nil)
(setq sccs-use-changelog t)




;;
;; PACKAGE: server                     Dist 18.58               
;;

(load-library "server")
(setq server-program "/usr/local/ls6/emacs-18.58/etc/server")
(server-start)




;;
;; PACKAGE: sh-mode             
;;





;;
;; PACKAGE: shadow-files                     1.2               
;;

(require 'shadow-files)



;;
;; PACKAGE: shell                     Dist 18.58               
;;

(defvar shell-mode-hook nil)
(setq shell-mode-hook
      (cons
       (function (lambda () 
                   (require 'fnexpand)
                   (local-set-key "\^I" 'complete-filename)))
       shell-mode-hook))



;;
;; PACKAGE: steve                1.18           
;;

(defun steve-func-keys ()
  (global-set-funkey "222z" 'narrow-to-next-page t)         ; PgDn
  (global-set-funkey "216z" 'narrow-to-previous-page t)     ; PgUp
; (global-set-funkey "214z" 'steve-beginning-of-buffer t)   ; R7   (Home)
; (global-set-funkey "220z" 'steve-end-of-buffer t)	      ; R13  (End)
; (global-set-funkey "\M->"   'end-of-buffer)
; (global-set-funkey "\M-<"   'beginning-of-buffer)
  )
(setq steve-mode-hook 'steve-func-keys)



;;
;; PACKAGE: supercite                     2.3               
;;

(set-variable 'sc-preferred-header-style 4)
(setq  sc-load-hook 
       '(lambda ()
          (defun sc-extract-namestring (from-string)
            "Extract the name string from FROM-STRING.
This should be the author's full name minus an optional title."
            (let ((istart (string-match "\\([^<]+\\) <" from-string 0))
                  (iend  (1-(match-end 0)))
                  (pstart (string-match "(.*)" from-string 0))
                  (pend (match-end 0))
                  (qstart (string-match "\".*\"" from-string 0))
                  (qend (match-end 0))
                  (bstart (string-match "\\([.a-zA-Z0-9_-]+\\s *\\)+" from-string 0))
                  (bend (match-end 0)))
              (sc-spacify-name-chars
               (cond
                ((sc-name-substring from-string istart iend 0))
                ((sc-name-substring from-string pstart pend 1))
                ((sc-name-substring from-string qstart qend 1))
                ((sc-name-substring from-string bstart bend 0))
                ))))
          (defun sc-remove-signature ()
            "Try to find a signature in the cited message an renove it."
            (interactive)
            (catch 'select-abort
              (undo-boundary)
              (let ((fp (sc-guess-fill-prefix)))
                (if fp
                    (let (end (fill-prefix fp))
                      ;;(message fp)(beep)(sleep-for 2)
                      (end-of-buffer)
                      (re-search-backward fp)
                      (end-of-line)
                      (setq end (point))
                      (backward-para 1)
                      (kill-region (point) end)
                      )))))))
(defvar mail-setup-hook nil)
(setq mail-setup-hook  
      (cons '(lambda () (local-set-key "\C-cs" 'sc-remove-signature))
            mail-setup-hook))



;;
;; PACKAGE: text-mode                     -*-               
;;





;;
;; PACKAGE: trash 1.1
;;





;;
;; PACKAGE: uncompress                     Dist 18.58               
;;

(load-library "uncompress")




;;
;; PACKAGE: util                     1.5               
;;

(load-library '"util")



;;
;; PACKAGE: vcs                     1.15 19-Sep-1992               
;;

(setq sccs-default-bindings t)
(setq vcs-use-default-bindings t)
(load-library "vcs-init")



;;
;; PACKAGE: vm                     5.31 (beta)               
;;

(setq vm-folder-directory "~/vmail")
(setq vm-confirm-new-folders t)
(setq vm-honor-page-delimiters t)
(setq vm-reply-subject-prefix "Re: ")
(setq vm-circular-folders nil)
(setq vm-startup-with-summary "both")
(setq pop-up-windows t)
(setq vm-preview-lines nil)
(setq vm-primary-inbox (concat vm-folder-directory "/INBOX"))
;; (setq vm-visit-when-saving nil)
;;
(defun remove-blanks (string)
  (if (string-match "\\([^ ]*\\)[ ]\\([^ ]*\\)" string)
      (concat (substring string (match-beginning 1) (match-end 1))
              (remove-blanks (substring string (match-beginning 2) 
                                        (match-end 2))))
    string))

(setq vm-auto-folder-alist
      '(("Subject"
         ("bib"      . "bib")
         ("SIMM\\|Platte\\|Speicher"     . "hw")
         )
        ("From"
         ;;("grossjoh" . "kai")
         ("bib"      . "bib")
         ("gitta"    . "gitta")
         ("SIMM\\|Platte\\|Speicher"     . "hw")
         ("uccvma"   . "InformationRetrievalList")  
         ("203" . "Venedig")
         ("204" . "Nosferatu")
         ("\\([^<]+\\)<.*>" . (remove-blanks 
                               (buffer-substring (match-beginning 1)
                                                  (match-end 1)))))
        ("To"
         ("grossjoh" . "kai")
         ("bib"      . "bib")
         ("gitta"    . "gitta")
         ("\\([^<]+\\)<.*>" . 
          (let ((name
                 (buffer-substring (match-beginning 1)
                                   (match-end 1))))
            (if (string= "UlrichPfeifer" name () (name)))))
        )))

(defvar vm-mode-hooks nil)
(setq vm-mode-hooks  
      (cons '(lambda ()
               (bbdb-insinuate-vm)
               (ISO-on)
               (autoload 'vm-burst-digest "vm-ir-digest" nil t))
            vm-mode-hooks))





;;
;; PACKAGE: wais                     8               
;;





;;
;; PACKAGE: wais-info                 1.4            
;;





;;
;; PACKAGE: wais-steve            1.2            
;;





;;
;; PACKAGE: wais-vm              1.1            
;;





;;
;; PACKAGE: wicos                     v1.4 ; 22 Sep 1992               
;;

(if local-disk
    (load-library "wicos"))




;;
;; PACKAGE: x-sb-mouse          1.6          
;;

(if (featurep 'x-mouse)
    (progn
      (defvar x-mouse-bind-hook nil "")
      (setq x-mouse-bind-hook 
            (cons
             '(lambda ()
                (setq x-mouse-auto-set-mark nil)
                
                ;; hyperbole
                ;;(setq x-mouse-c1-window-click 'sm-mouse-window-click)
                ;;(setq x-mouse-c3-window-click 'sm-mouse-meta-window-click)
                ;;(setq x-mouse-c1-mini-click 'sm-mouse-window-click)
                ;;(setq x-mouse-c3-mini-click 'sm-mouse-meta-window-click)
                
                (x-mouse-define-key "x-mouse-cm1-window-drag"   t
                                    'default 'x-mouse-copy-rectangle-to-000)
                (x-mouse-define-key "x-mouse-cms1-window-drag"  t
                                    'default 'x-mouse-kill-rectangle-to-000)
                (x-mouse-define-key "x-mouse-cm1-window-click"  t
                                    'default 'x-mouse-select-and-split)
                (x-mouse-define-key "x-mouse-cm2-window-click"  t
                                    'default 'x-mouse-keep-one-window)
                (x-mouse-define-key "x-mouse-cms2-window-click" t
                                    'default 'x-mouse-insert-rectangle-000-here)
                (x-mouse-define-key "x-mouse-cs2-window-click"  t
                                    'default 'x-help)
                (x-mouse-define-key "x-mouse-cm3-window-click"  t
                                    'default 'x-mouse-copy-kill-to-x)
                (x-mouse-define-key "x-mouse-1-mini-click"      t
                                    'default 'x-mouse-set-point)
                (x-mouse-define-key "x-mouse-cm1-mini-click"    t
                                    'default 'repeat-complex-command-1)
                (x-mouse-define-key "x-mouse-2-mini-click"      t
                                    'default 'x-mouse-paste-text)
                (x-mouse-define-key "x-mouse-cm2-mini-click"    t
                                    'default 'previous-complex-command-1)
                (x-mouse-define-key "x-mouse-3-mini-click"      t
                                    'default 'x-mouse-paste-there)
                (x-mouse-define-key "x-mouse-cm3-mini-click"    t
                                    'default 'next-complex-command-1))
             x-mouse-bind-hook 
             ))
      ;; (run-hooks 'x-mouse-bind-hook)
      ))



