########################## -*- Mode: Perl -*- ##########################
##
## File             : client_common.pl
##
## Description      : common code for waisperl and plain perl
##
#
# Copyright (C) 1995, 1996 Ulrich Pfeifer, Norbert Goevert
#
# This file is part of SFgate.
#
# SFgate is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# SFgate is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with SFgate; see the file COPYING.  If not, write to
# the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
#
##
## Author           : Ulrich Pfeifer
## Created On       : Thu Jun 23 16:00:30 1994
##
## Last Modified By : Norbert Goevert
## Last Modified On : Thu Jan 16 16:10:21 1997
##
## $State: Exp $
##
## $Id: client_common.pl,v 5.1.1.3 1997/02/17 12:57:23 goevert Exp goevert $
##
## $Log: client_common.pl,v $
## Revision 5.1.1.3  1997/02/17 12:57:23  goevert
## patch10: handling for WAIT databases
##
## Revision 5.1.1.2  1997/01/10 10:36:28  goevert
## patch9: changed relative links
##
## Revision 5.1.1.1  1996/12/23 12:53:34  goevert
## patch6: query is shown on pages with retrieved documents now
##
## Revision 5.1  1996/11/05 16:55:56  goevert
## *** empty log message ***
##
## Revision 5.0.1.8  1996/11/04 13:11:13  goevert
## patch21: cons instead of MakeMaker
##
## Revision 5.0.1.7  1996/07/04 13:11:32  goevert
## patch20:  fixed bug with printing of wais source descriptions
##
## Revision 5.0.1.6  1996/06/04 16:18:01  goevert
## patch17: handling of <HR>
##
## Revision 5.0.1.5  1996/05/31 15:47:22  goevert
## patch14: request method handling
## patch14: SFgate-server
## patch14: minor fixings
##
## Revision 5.0.1.4  1996/05/23 17:09:25  goevert
## patch13: converter for headlines
## patch13: fixed table listenv format
##
## Revision 5.0.1.3  1996/05/15 17:08:02  goevert
## patch10:
##
## Revision 5.0.1.2  1996/05/13 11:31:11  goevert
## patch1:
##
########################################################################


sub encode_entities
{
    local($_) = @_;

    ## encode <, > but preserve highlighting tags <B> and </B>
    s/<B>(\S+)<\/B>/\000$1\001/g;
    s/</&lt\;/g;
    s/>/&gt\;/g;
    
    ## encode 'standalone' & but preserve '&...;'
    # escape '&...;' to '&<...>;'
    s/&(\#[0-9]{1,3}\;)/&<$1>/g;
    s/&([A-z0-9]{2,6}\;)/&<$1>/g;
    # encode &
    s/&([^<])/&amp;$1/g;
    # unescape '&<...>;' to '&...;'
    s/&<(\#[0-9]{1,3};)>/&$1/g;
    s/&<([A-z0-9]{2,6};)>/&$1/g;
    s/&$/&amp\;/;

    s/\000(\S+)\001/<B>$1<\/B>/g;

    $_;
}


sub parse_wsrc
{
    local($_) = join('', @_);
    local($databasename, $ipname, $tcpport, $description);

    ($databasename) = m/:database-name\s+\"([^\"]*)\"/; 
    ($ipname)       = m/:ip-name\s+\"([^\"]*)\"/;
    ($ipname)       = m/:ip-address\s+\"([^\"]*)\"/ unless $ipname;
    ($tcpport)      = m/:tcp-port\s+([0-9]+)/;
    ($description)  = m/:description\s+\"([^\"]*)\"/;

    $tcpport = 210 unless $tcpport;

    if (!$description) {
        # '_parse_wsrc' = No description available.
        $description = $language{'parse_wsrc'};
    }

    # error: source description couldn't be parsed
    return unless $databasename && $ipname;
    
    return($databasename, $ipname, $tcpport, $description);
}


sub init_plain
{
    my($num, $prior_query, $conditions) = @_;
    ## local variables
    my($convert_entry, $description, $converter, $checked);
    
    $listenv_open = 0;

    if ($multiple_choice == 2) {
        # output of retrieved documents
        if ($num == 1) {
            # '_init_plain1' = You\'ve chosen <B>one</B> document:
            print "\n$language{'init_plain1'}\n";
        }
        elsif ($num > 1) {
            # '_init_plain2' = You\'ve chosen <B>
            # '_init_plain3' = </B> documents:
            print "\n$language{'init_plain2'}$num".
                "$language{'init_plain3'}\n";
        }
        else {
            # '_init_plain4' = You didn't choose any documents!
            print "\n\n$language{'init_plain4'}\n";
        }
        $hr = 0;
    }
    else {
        # output of search results
        if ($num == 1) {
            # '_init_plain5' = The selected databases contain <B>one</B>
            #                  document matching your query:
            print "\n$language{'init_plain5'}\n";
            $hr = 0;
        }
        elsif ($num > 1) {
            # '_init_plain6' = The selected databases contain <B>
            # '_init_plain7' = </B> documents matching your query:
            print "\n$language{'init_plain6'}$num$language{'init_plain7'}\n";
            $hr = 0;
        }
        elsif (!$wsrc_form) {
            # '_init_plain8' = The selected databases contain <B>no</B>
            #                  item matching your query.
            print "\n$language{'init_plain8'}\n";
            print "<!-- EMPTY RESULT -->\n";
            $hr = 0;
        }
    }
    
    if (!$directget && $multiple_choice == 1 && $num) {
        # test for converter configuration
        $convert_entry = "<INPUT TYPE=\"hidden\" NAME=\"$convert_field\" VALUE=\"$convert\">";
        if ($convertm) {
            # '_init_plain9' = Conversion of documents:
            $convert_entry = "$language{'init_plain9'} <BR>\n";
            foreach (split(';', $convertm)) {
                ($converter, $description) = split(',', $_, 2);
                $checked = '';
                $checked = 'CHECKED ' if $converter eq $convert;
                $description = $converter if !$description;
                $convert_entry .= "<INPUT TYPE=\"radio\" NAME=\"convert\" " .
                     $checked . "VALUE=\"$converter\"> $description <BR>\n"; 
            }
            $convert_entry .= "\n <P>\n";
        }
        # open form
        # '_init_plain10' = Select some of the following documents:
        # '_init_plain11' = fetch documents
        # '_init_plain12' = new choice
        print <<"EOF";
        
 <HR>

<B>$language{'init_plain10'}</B>

<FORM METHOD="$requestm" ACTION="$htbin/$me">

 <P>

$convert_entry

<INPUT TYPE="submit" VALUE="$language{'init_plain11'}">
<INPUT TYPE="reset"  VALUE="$language{'init_plain12'}">

<INPUT TYPE="hidden" NAME="$multiple_field"    VALUE="2">
<INPUT TYPE="hidden" NAME="$language_field"    VALUE="$language">
<INPUT TYPE="hidden" NAME="$verbose_field"     VALUE="$verbose_headlines">
<INPUT TYPE="hidden" NAME="$listenv_field"     VALUE="$listenv">
<INPUT TYPE="hidden" NAME="$application_field" VALUE="$application">
<INPUT TYPE="hidden" NAME="$converthl_field"   VALUE="$converthl">
<INPUT TYPE="hidden" NAME="$refinequery_field" VALUE="$refinequery">
<INPUT TYPE="hidden" NAME="$formintern_field"  VALUE="$formintern">
<INPUT TYPE="hidden" NAME="$formextern_field"  VALUE="$formextern">
<INPUT TYPE="hidden" NAME="$transquery_field"  VALUE="$transquery">
<INPUT TYPE="hidden" NAME="$_lines_field"      VALUE="$_lines">
EOF
    ;
        if ($highlight) {
            print <<"EOF";
<INPUT TYPE="hidden" NAME="$conditions_field"  VALUE="$conditions">
EOF
;
        }
    }
    
    unless ($hr) {
        print "\n <HR>\n";
        $hr = 1;
    }

    if ($prior_query) {
        # '_init_plain12' = Prior documents...
        print "<A HREF=\"$htbin/$me?$prior_query\">",
        $language{'init_plain13'}, "</A>\n\n <HR>\n\n";
        $hr = 1;
    }
}


sub exit_plain
{
    if ($listenv_open) {
        print "</$listenv>\n";
        print "\n</FORM>\n" if $multiple_choice == 1;
        $listenv_open = 0;
    }
    unless ($hr) {
        print "\n <HR>\n";
        $hr = 1;
    }
}


sub init_form
{
    local($num) = @_;

    $wsrc_form = 1;
    
    if ($num == 1) {
        # '_init_form1' = The selected databases contain <B>one</B>
        #                  database description matching your query:
        print "\n$language{'init_form1'}\n";
    }
    else {
        # '_init_form2' = The selected databases contain <B>
        # '_init_form3' = </B> database descriptions matching your query:
        print "\n$language{'init_form2'}$num$language{'init_form3'}\n";
    }
  
    # '_init_form4' = Select some of the following databases and enter your query:
    # '_init_form5' = start search
    # '_init_form6' = reset query
   print <<"EOF";

 <HR>

<B>$language{'init_form4'}</B>

<FORM METHOD="$requestm" ACTION="$htbin/$me">

 <P>

<TEXTAREA NAME="text" TYPE="TEXT" ROWS="5" COLS="40">
</TEXTAREA>

 <P>
     
<INPUT TYPE="submit" VALUE="$language{'init_form5'}">
<INPUT TYPE="reset"  VALUE="$language{'init_form6'}">

 <HR>

<DL>
EOF
    ;                          
}


sub exit_form
{
    # '_exit_form1' = Enter your query:
    print <<"EOF";
</DL>

</FORM>
    
 <HR>
EOF
    ;
    $hr = 1;
}
    

sub form_entry
{
    local($ipname, $tcpport, $databasename, $description) = @_;

    print <<"EOL"
<DT> <INPUT NAME="database"
            TYPE="checkbox"
           VALUE="$ipname:$tcpport/$databasename">
     <B>$databasename</B>
<DD> <PRE>$description</PRE>
EOL
    ;
}


sub print_wsrc
{
    my(@headlines) = @_;
    ## local variables
    local($_);

    # handle server descriptions
    my(@other_headlines, @wsrc_headlines);
    foreach (@headlines) {

        if (!defined($_->[1]->{'WSRC'})) {
            push(@other_headlines, $_);
            next;
        }
        
        push(@wsrc_headlines, $_->[1]->{'WSRC'});
        delete $_->[1]->{'WSRC'};

        my(@newtypes, $type);
        foreach $type (@{$_->[0]->[5]}) {
            push(@newtypes, $type) if $type ne 'WSRC';
        }
        if (@newtypes) {
            $_->[0]->[5] = @newtypes;
            push(@other_headlines, $_);
        }
    }

    my $num = @wsrc_headlines;
    if ($num) {
        &init_form($num);
        while (@wsrc_headlines) {
            my $text = shift(@wsrc_headlines);
            my($dbname, $ipname, $tcpport, $description) = &parse_wsrc($text);
            if ($ipname) {
                $description = &encode_entities($description);
                &form_entry($ipname, $tcpport, $dbname, $description);
            }
            else {
                # 'print_wsrc' = Wais source description could not be parsed:
                $text = &encode_entities($text);
                print <<"EOL"
<DT> $language{'print_wsrc'}
<DD> <PRE>$text</PRE>
EOL
    ;
            }
        }
        &exit_form;
    }
    
    @headlines = @other_headlines;

    return(@headlines);
}


sub print_headlines
{
    my($databases, $headlines, $prior_query, $conditions) = @_;
    ## local variables
    local($_);
    my($urlprefix, $num, $rank);
    my($tag, $score, $lines, $size, $headline, $types, $docid);
    my($server, $database, $local_id, $file);
    my($type, $text, $descriptor, $url);


    my($url_conditions, $form_conditions, %positions);
    if ($conditions) {
        # do highlighting
        if ($directget || $multiple_choice == 2) {
            # highlighting has to be done now
            my $headline;
            my($tag, $docid);
            my %highlight;
            foreach $headline (@$headlines) {
                $tag   = $headline->[0]->[0];
                $docid = $headline->[0]->[6];
                my $database_file = $databases->get_database_file($tag);
                # highlighting only possible with local datbases
                next unless -e "$database_file.doc"; 
                push(@{$highlight{$database_file}->[0]}, $docid);
                $highlight{$database_file}->[1] = $conditions;
                $highlight{$database_file}->[1] = $databases->get_conditions($tag)
                    if defined($databases->get_conditions($tag));
            }
            my $highlight = new SFgate::Highlight (%highlight);
            %positions = $highlight->highlight;
        }
        else {
            # provide highlighting informations in forms and URLS
            my $condition;
            foreach $condition (@$conditions) {
                $url_conditions .= $seperator x 2 .
                    join($seperator, @$condition);
            }
            $url_conditions = &encode($url_conditions);
            $form_conditions = $databases->get_encoded_conditions;
            if ($form_conditions) {
                $form_conditions .= $seperator x 3;
                $form_conditions = &encode($form_conditions);
            }
            $form_conditions .= $url_conditions;
        }
    }

    
    $urlprefix = "$htbin/$me?" .
        "$language_field="     . $language             .
        "&$verbose_field="     . $verbose_headlines    .
        "&$listenv_field="     . $listenv              .
        "&$application_field=" . $application          .
        "&$convert_field="     . $convert              .
        "&$converthl_field="   . $converthl            .
        "&$refinequery_field=" . &encode($refinequery) .
        "&$formintern_field="  . $formintern           .
        "&$formextern_field="  . $formextern           .
        "&$transquery_field="  . $transquery           .
        "&$_lines_field="      . $_lines               .
        "&$multiple_field=0";

    $num = @$headlines;

    &init_plain($num, $prior_query, $form_conditions);
    return unless $num;
    
    # handle other document types than WSRC
    $rank = $range - 1 if $range;
    foreach (@$headlines) {

        $rank++;

        ($tag, $score, $lines, $size, $headline, $types, $docid) = @{$_->[0]};
        ($server, $database, $local_id) = $docid->split;
        
        $file = (split(' ', $local_id))[2];
        
        foreach $type (@$types) {

            if (defined($_->[1]->{$type})) {
                $text = $_->[1]->{$type};
            }
            else {
                $text = '';
            }

            if ($text && $type eq 'URL') {
                $type = "HTML";
            }

            if ($text
                && &print_text($type, $text, $headline, 'inline', $databases, $tag,
                               $positions{$docid})) {
                # we have the text already: if something went wrong
                # with printing, give a pointer
                next;
            }

            # build the documentdescriptor
            $descriptor = join($seperator, ($tag,
                                            $score,
                                            $size,
                                            $headline,
                                            $type,
                                            $server,
                                            $database,
                                            $local_id));

            $descriptor = &encode($descriptor);
            $url = $urlprefix . '&' . $descriptor_field . '=' . $descriptor;
            if ($conditions && $highlight) {
                my $tag_conditions = &encode($databases->get_encoded_conditions($tag));
                $tag_conditions = $url_conditions if !$tag_conditions;
                $url .= '&' . $conditions_field . '=' . $tag_conditions;
            }
            if ($type eq 'URL' && $directhttp) {
                $url = $file;
            }

            &print_anchor($descriptor,
                          $url,
                          $headline,
                          $database,
                          $size,
                          $type,
                          $score,
                          $rank);
        }
    }
    
    &exit_plain;
}


sub print_anchor
{
    my($descriptor, $url, $headline, $database, $size, $type, $score, $rank) = @_;
    ## local variables
    my($anchor);

    $hr = 0;
    if (!$listenv_open && $listenv !~ /table/i) {
        print "\n<$listenv>\n";
        $listenv_open = 1;
    }
    
    if ($size > 1024) {
        $size = sprintf("%6.1f kbytes", $size/1024);
    }
    else {
        $size .= " bytes";
    }

    if ($converthl) {
        no strict 'refs';
        $anchor = &$converterhl($headline, $url);
    }
    else {
        $anchor = '<A HREF="' . $url . '">' . &encode_entities($headline) . '</A>';    
    }

    # remove path from database
    $database =~ s:.*/::;
    
    # continue according to listenv settings
    
    if ($listenv =~ /table/i) {
        print "\n<table>\n";
        my $add = '&nbsp; ' if $rank < 10;
        $anchor1 = "<TR VALIGN=\"top\">\n" . '  <TH>' . $add . $rank . ":</TH>\n";
        if ($multiple_choice == 1) {
            $anchor1 .= '  <TD> <INPUT NAME="' . $document_field . '" ' .
                'TYPE="checkbox" VALUE="' . $descriptor . "\"></TD>\n";
        }

        $anchor = $anchor1 . '  <TD ALIGN="left">' . $anchor . "</TD>\n</TR>\n";
        if ($verbose_headlines) {
            $anchor .= "<TR>\n  <TD></TD>\n";
            $anchor .= "  <TD></TD>\n" if $multiple_choice == 1;
            $anchor .= '  <TD> ' .
                $language{'print_anchor1'} . " <B>$database</B>, " .
                $language{'print_anchor2'} . " <B>$size</B>, "     .
                $language{'print_anchor3'} . " <B>$type</B>, "     .
                $language{'print_anchor4'} . " <B>$score</B>"      .
                "</TD>\n</TR>";
        }
        print $anchor;
        print '</table>';
        return;
    }

    # for <DL> and <PRE>
    if ($multiple_choice == 1) {
        $anchor = '<INPUT NAME="' . $document_field . '" ' .
            'TYPE="checkbox" VALUE="' . $descriptor . '"> ' . $anchor;
    }

    if ($verbose_headlines) {
        $anchor = "<B>$anchor</B>";
    }
    $anchor = "<B>$rank:</B> $anchor\n";
    
    if ($listenv =~ /DL/i) {
        $anchor = '<DT> '.$anchor."<DD>";
        $anchor .= "\n" if !$verbose_headlines;
    }

    if ($verbose_headlines) {
        # '_print_anchor1' = Database:
        # '_print_anchor2' = Size:
        # '_print_anchor3' = Type:
        # '_print_anchor4' = Score:
        $anchor .= '    '.
            $language{'print_anchor1'} . " <B>$database</B>, " .
            $language{'print_anchor2'} . " <B>$size</B>, "     .
            $language{'print_anchor3'} . " <B>$type</B>, "     .
            $language{'print_anchor4'} . " <B>$score</B>\n";
    }

    print $anchor;
}
    

## #################################################################
## print_diagnostics
## #################################################################
## Prints global hash %diagnostics in HTML to STDOUT
##
sub print_diagnostics
{
    my(%diagnostics) = @_;
    ## local variables
    my($server, $diagnostic);

    return unless (keys %diagnostics);

    print "\n <HR>\n" unless $hr;
    $hr = 1;
    
    # '_print_diagnostics1' = Diagnostics
    # '_print_diagnostics2' = Server <B>
    # '_print_diagnostics3' = </B> returns the following diagnostics:
    print "<H2>$language{'print_diagnostics1'}</H2>\n";
    foreach $server (keys %diagnostics) {

        print <<"EOS"
$language{'print_diagnostics2'}$server$language{'print_diagnostics3'}

<PRE>
EOS
    ;
        foreach $diagnostic (@{$diagnostics{$server}}) {
            print $diagnostic;
        }
        print "</PRE>\n";
    }

    print "\n <HR>\n";
}


sub print_text
{
    my($type, $text, $headline, $inline, $databases, $tag, $positions) = @_;
    ## local variables
    my($title, $titletag, $titlepos);

    $title = $headline;
    
    if ($type =~ /GIF/) {
        ## handle gif
        return(0) if $inline;
        print "Content-Type: image/gif\n\n$text";
        return(1);
    }
    elsif ($type =~ /MIME/) {
        ## handle mime
        return(0) if $inline;
        print "Content-Type: application/metamail\n\n$text";
        return(1);
    }
    elsif ($type =~ /PS/) {
        ## handle postscript
        return(0) if $inline;
        print "Content-Type: application/postscript\n\n$text";
        return(1);
    }
    elsif ($type =~ /HTML|URL/) {
        ## handle html code
        $text = &SFgate::Highlight::mark_text($text, $positions) if $positions;
        # remove original header
        $text =~ s:</?(BODY|HTML|HEAD)>::ig;
        # find title and remove it
        if ($text =~ /(<title>)/i) {
            $titletag = $1;
            $titlepos = index($text, $titletag);
            $title = substr($text, $titlepos + 7, 300);
            $title =~ s:(</title>)(.|\n)*::i;
            $text = substr($text, 0, $titlepos).
                substr($text, $titlepos + 7 + length($title) + length($1));
        }
    }
    elsif ($databases->get_server($tag) ne 'wait' && $type !~ /TEXT|WSRC/)  {
        ## handle unknown content types
        return(0) if $inline;
        if ($type =~ m:/:) {
            print "Content-Type: $type\n\n";
        }
        print $text;
    }
    elsif ($databases->get_server($tag) ne 'wait') {
        $text = &SFgate::Highlight::mark_text($text, $positions) if $positions;
    }
    
    ## handle HTML, URL, TEXT, WSRC
    if ($databases->get_server($tag) ne 'wait' && $convert) {
        $converter = $databases->get_converter($tag, $convert);
        require "SFgate/Converter/$converter.pm";
        $converter = 'SFgate::Converter::' . $converter . '::convert';
        no strict 'refs';
        ($text, $headline) = &$converter($text, $headline);
    }
    elsif ($databases->get_server($tag) ne 'wait' && $type !~ /HTML|URL/) {
        $text = "<PRE>\n" . &encode_entities($text) . "</PRE>\n";
    }

    if ($inline) {
        if ($listenv_open) {
            print "</$listenv>\n";
            $listenv_open = 0;
        }
        unless ($hr) {
            print "\n <HR>\n\n";
            $hr = 1;
        }
    }
    else {
        $title = $headline if $headline;
        &print_header($title) unless $debug;
        &print_queries($transquery);
        my($hr);
        if ($formintern || $formextern) {
            %values = &parse_query_string($refinequery);
            $hr = &print_forms($formintern, $formextern, %values);
        }

        unless ($hr) {
            print "\n <HR>\n";
            $hr = 1;
        }
        %diagnostics = $databases->get_diagnostics;
        &print_diagnostics(%diagnostics);
    }
        
    print "<H2>$headline</H2>\n" if $headline;

    print $text;
    
    print "\n <HR>\n";
    $hr = 1;
    
    # printing was successful
    return 1;
}


# logging messages
sub log
{
    local($_) = @_;
    
    return unless $logging;
        
    if (!open (TMP, ">> $log_file")) {
        $logging = 0;
        return; 
    }
        
    print TMP &timestring . ' ' . $$ . ' ' . $_ . "\n";

    close(TMP);
}


# debugging messages
sub dprint
{
    return unless $debug;
    
    print "\n<PRE>\n";
    print @_;
    print "</PRE>\n";
}


# converting time
sub timestring
{
    my(@day_names)   = ("Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat");
    my(@month_names) = ("Jan", "Feb", "Mar", "Apr", "May", "Jun",
                        "Jul", "Aug", "Sep", "Oct", "Nov", "Dec");

    my($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $iddst) = 
        localtime(time);
    
    sprintf ("%s, %d %s %02d %02d:%02d:%02d",
             $day_names[$wday],
             $mday,
             $month_names [$mon],
             $year, $hour, $min, $sec);
}



