#!/bin/sh -- # -*- perl -*- -w
########################## -*- Mode: Perl -*- ##########################
##
## File             : Swedish.pm
##
## Description      : SFgate messages in swedish
##
#
# Copyright (C) 1996 Ulrich Pfeifer, Norbert Goevert
#
# This file is part of SFgate.
#
# SFgate is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# SFgate is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with SFgate; see the file COPYING.  If not, write to
# the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
#
## Author           : Norbert Goevert
## Created On       : Mon Oct 14 08:22:44 1996
##
## Last Modified By : Norbert Goevert
## Last Modified On : Thu Nov 21 12:51:29 1996
##
## $State: Exp $
##
## $Id: Swedish.pm,v 5.1.1.1 1996/12/23 12:51:37 goevert Exp goevert $
##
## $Log: Swedish.pm,v $
## Revision 5.1.1.1  1996/12/23 12:51:37  goevert
## patch6: introduction of $wildcard_regexp
##
## Revision 5.1  1996/11/05 16:55:48  goevert
## *** empty log message ***
##
## Revision 5.0.1.1  1996/11/04 13:10:45  goevert
## patch21: new language extensions
##
########################################################################

# Thanks to Sven Wijk <svenw@sgu.se>
# for providing these translations


package SFgate::Language::Swedish;

use strict;
no strict 'vars';

# make perl -w happy
$and_regexp       = '';
$or_regexp        = '';
$not_regexp       = '';

$plaintext_regexp = '';
$soundex_regexp   = '';
$phonix_regexp    = '';
$wildcard_regexp  = '';

%language         = ();


## #####################################################################
## settings
## #####################################################################

$and_regexp       = 'and|och'; 
$or_regexp        = 'or|eller';
$not_regexp       = 'not|icke';

$plaintext_regexp = 'text|plain|strict';
$soundex_regexp   = 'soundex';
$phonix_regexp    = 'phonix';
$wildcard_regexp  = 'wildcard';

%language = (
             # client_common
             'parse_wsrc',         'Ingen beskrivning tillg&auml;nglig.',
             'print_wsrc',         'Wais-databasbeskrivningen kunde icke tolkas:',
             'init_plain1',        'Du har valt <B>ett</B> dokument:',
             'init_plain2',        'Du har valt <B>',
             'init_plain3',        '</B> dokument:',
             'init_plain4',        'Du valde inga dokument!',
             'init_plain5',        'Den valda databasen inneh&aring;ller <B>ett</B> dokument som motsvarar er s&ouml;kfr&aring;ga:',
             'init_plain6',        'Den valda databasen inneh&aring;ller <B>',
             'init_plain7',        '</B> dokument som motsvarar er s&ouml;kfr&aring;ga:',
             'init_plain8',        'Den valda databasen inneh&aring;ller <B>inget</B> dokument som motsvarar er s&ouml;kfr&aring;ga.',
             'init_plain9',        'Konvertering av dokument:',
             'init_plain10',       'V&auml;lj n&aring;gra av f&ouml;ljande dokument:',
             'init_plain11',       'H&auml;mta dokumenten',
             'init_plain12',       'nytt val',
             'init_plain13',       'Tidigare dokument...',
             'init_form1',         'Den valda databasen inneh&aring;ller <B>en</B> databasbeskrivning som motsvarar er s&ouml;kfr&aring;ga.',
             'init_form2' ,        'Den valda databasen inneh&aring;ller <B>',
             'init_form3',         '</B> databasbeskrivning som motsvarar er s&ouml;kfr&aring;ga:',
             'init_form4',         'V&auml;lj n&aring;gra av f&ouml;ljande databaser och skriv in er s&ouml;kfr&aring;ga:',
             'init_form5',         'starta s&ouml;kningen',
             'init_form6',         '&aring;terst&auml;ll s&ouml;kfr&aring;gan',
             'print_anchor1',      'Databas:',
             'print_anchor2',      'Storlek:',
             'print_anchor3',      'Typ:',
             'print_anchor4',      'Score:',
             'print_diagnostics1', 'Diagnos',
             'print_diagnostics2', 'Server <B>',
             'print_diagnostics3', '</B> ger f&ouml;ljande diagnos:',
             # search_index.pl
             'do_request1',        'kunde inte l&auml;sa dokumentet:',
             'do_request2',        'WAIS-dokument',
             'do_request3',        'F&ouml;rs&ouml;k att n&aring; det direkt!',
             'do_request4',        'debug',
             'do_request5',        'Du specificerade ingen s&ouml;kfr&aring;ga.',
             'do_request6',        'i',
             'do_request7',        'Du valde inga databaser.',
             'print_queries1',     'Er s&ouml;kfr&aring;ga var:',
             'print_queries2',        'Queries in Databases:',
             'print_forms',           'Refine your query',
             'dumpenv',            'Dump av omgivningsvariabler',
             'print_footer1',      'Ytterligare dokument...',
             'print_footer2',      'Denna sida genererades av',
             'do_sorry1',          'Syntaxfel i s&ouml;kfr&aring;ga',
             'do_sorry2',          'Tyv&auml;rr! Kan inte tolka er s&ouml;kfr&aring;ga:',
             'main1',              'avslutad',
             'main2',              'avslutad med meddelandet',
             'main3',              'Var v&auml;nlig kontakta webmaster',
             'main4',              'Besynnerligt fel',
             'main5',              '&auml;r inte',
             'main6',              'Vem anropade mig?',
             # query.pl
             'translate_query',    'Kunde inte tolka datumf&auml;ltet',
             # parse_query.pl
             'parse_query1',       'Slut p&aring; s&ouml;kfr&aring;ga efter operator',
             'parse_query2',       'ov&auml;ntad slutparantes',
             'parse_query3',       'ov&auml;ntad slutklammer',
             'parse_query4',       'ov&auml;ntad operator',
             'parse_query5',       'ov&auml;ntad numeriskt predikat',
             'parse_query6',       'ov&auml;ntad',
             'parse_query7',       'avsaknad s&ouml;kkriterium efter startparantes',
             'parse_query8',       'avsaknad slutparantes',
             'parse_query9',       'ingen avgr&auml;nsare f&ouml;r ordagrann s&ouml;kning:',
             'parse_query10',      'atleast-operator utan numeriskt argument',
             'parse_query11',      'atleast operator utan term',
             'parse_query12',      'n&auml;stlade indextyplistor &auml;r inte m&ouml;jliga',
             'parse_query13',      'avsaknad startparantes f&ouml;r indextyplista',
             'parse_query14',      'avsaknad s&ouml;kfr&aring;ga f&ouml;r indextyplista',
             'parse_query15',      'avsaknad slutparantes f&ouml;r indextyplista',
             'parse_query16',      'ingen term f&ouml;r indextyp',
             'parse_query17',      'proximity operator',
             'parse_query18',      'utan numeriskt argument st&ouml;rre &auml;n 0',
             'parse_query19',      'utan andra term',
             'parse_query20',      'n&auml;stlade f&auml;ltuttryck inte m&ouml;jliga',
             'parse_query21',      'icke numeriskt argument med numeriskt predikat',
             'parse_query22',      'avsaknad s&ouml;kfr&aring;ga i f&auml;ltutryck'
            );


1;

