########################## -*- Mode: Perl -*- ##########################
##
## File             : English.pm
##
## Description      : SFgate messages in english
##
#
# Copyright (C) 1996 Ulrich Pfeifer, Norbert Goevert
#
# This file is part of SFgate.
#
# SFgate is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# SFgate is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with SFgate; see the file COPYING.  If not, write to
# the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
#
##
## Author           : Norbert Goevert
## Created On       : Tue Mar  5 13:33:38 1996
##
## Last Modified By : Norbert Goevert
## Last Modified On : Tue Jan 14 14:47:00 1997
##
## $State: Exp $
##
## $Id: English.pm,v 5.1.1.2 1997/02/17 12:56:51 goevert Exp goevert $
##
## $Log: English.pm,v $
## Revision 5.1.1.2  1997/02/17 12:56:51  goevert
## patch10: minor fixing
##
## Revision 5.1.1.1  1996/12/23 12:51:21  goevert
## patch6: introduction of $wildcard_regexp
##
## Revision 5.1  1996/11/05 16:55:33  goevert
## *** empty log message ***
##
## Revision 5.0.1.3  1996/05/31 15:44:55  goevert
## patch14: language handling changed (SFgate-server)
##
## Revision 5.0.1.2  1996/05/15 17:07:49  goevert
## patch10:
##
## Revision 5.0.1.1  1996/05/13 11:29:24  goevert
## patch1:
##
########################################################################


package SFgate::Language::English;

use strict;
no strict 'vars';

# make perl -w happy
$and_regexp       = '';
$or_regexp        = '';
$not_regexp       = '';

$plaintext_regexp = '';
$soundex_regexp   = '';
$phonix_regexp    = '';
$wildcard_regexp  = '';

%language         = ();


## #####################################################################
## settings
## #####################################################################

$and_regexp       = 'and'; 
$or_regexp        = 'or';
$not_regexp       = 'not';

$plaintext_regexp = 'text|plain|strict';
$soundex_regexp   = 'soundex';
$phonix_regexp    = 'phonix';
$wildcard_regexp  = 'wildcard';

%language = (
             # client_common
             'parse_wsrc',         'No description available.',
             'print_wsrc',         'Wais source description could not be parsed:',
             'init_plain1',        'You\'ve chosen <B>one</B> document:',
             'init_plain2',        'You\'ve chosen <B>',
             'init_plain3',        '</B> documents:',
             'init_plain4',        'You didn\'t choose any documents!',
             'init_plain5',        'The selected databases contain <B>one</B> document matching your query:',
             'init_plain6',        'The selected databases contain <B>',
             'init_plain7',        '</B> documents matching your query:',
             'init_plain8',        'The selected databases contain <B>no</B> item matching your query.',
             'init_plain9',        'Conversion of documents:',
             'init_plain10',       'Select some of the following documents:',
             'init_plain11',       'fetch documents',
             'init_plain12',       'new choice',
             'init_plain13',       'Prior documents...',
             'init_form1',         'The selected databases contain <B>one</B> database description matching your query:',
             'init_form2',         'The selected databases contain <B>',
             'init_form3',         '</B> database descriptions matching your query:',
             'init_form4',         'Select some of the following databases and enter your query:',
             'init_form5',         'start search',
             'init_form6',         'reset query',
             'print_anchor1',      'Database:',
             'print_anchor2',      'Size:',
             'print_anchor3',      'Type:',
             'print_anchor4',      'Score:',
             'print_diagnostics1', 'Diagnostics',
             'print_diagnostics2', 'Server <B>',
             'print_diagnostics3', '</B> returns the following diagnostics:',
             # search_index.pl
             'do_request1',        'couldn\'t retrieve the document:',
             'do_request2',        'WAIS documents',
             'do_request3',        'Try to get it directly!',
             'do_request4',        'debug',
             'do_request5',        'You didn\'t specify a query.',
             'do_request6',        'in',
             'do_request7',        'You didn\'t select any databases.',
             'print_queries1',     'Your query was:',
             'print_queries2',     'Queries in Databases:',
             'print_forms',        'Refine your query',
             'dumpenv',            'Dump Environment',
             'print_footer1',      'Further documents...',
             'print_footer2',      'This page was generated by',
             'do_sorry1',          'Syntax error in query',
             'do_sorry2',          'Sorry! Can\'t parse your query:',
             'main1',              'terminated',
             'main2',              'terminated with message',
             'main3',              'Please contact the webmaster.',
             'main4',              'Strange Error',
             'main5',              'is not',
             'main6',              'Who called me then?',
             # query.pl
             'translate_query',    'Couldn\'t parse date field',
             # parse_query.pl
             'parse_query1',       'end of query after operator',
             'parse_query2',       'unexpected closing parenthesis',
             'parse_query3',       'unexpected closing bracket',
             'parse_query4',       'unexpected operator',
             'parse_query5',       'unexpected numeric predicate',
             'parse_query6',       'unexpected',
             'parse_query7',       'missing query after opening parenthesis',
             'parse_query8',       'missing closing parenthesis',
             'parse_query9',       'no literal search delimiter',
             'parse_query10',      'atleast operator without numeric argument',
             'parse_query11',      'atleast operator without term',
             'parse_query12',      'nested indextypelists not possible',
             'parse_query13',      'missing opening bracket after indextypelist',
             'parse_query14',      'missing query after indextypelist',
             'parse_query15',      'missing closing bracket after indextypelist',
             'parse_query16',      'no term with indextype',
             'parse_query17',      'proximity operator',
             'parse_query18',      'without numeric argument greater than zero',
             'parse_query19',      'without 2nd term',
             'parse_query20',      'nested fieldexpressions not possible',
             'parse_query21',      'non numeric argument with numeric predicate',
             'parse_query22',      'missing query in fieldexpression'
             );


1;
