########################## -*- Mode: Perl -*- ##########################
##
## File             : IZ.pm
##
## Description      : converts IZ documents
##
#
# Copyright (C) 1996 Ulrich Pfeifer, Norbert Goevert
#
# This file is part of SFgate.
#
# SFgate is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# SFgate is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with SFgate; see the file COPYING.  If not, write to
# the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
#
##
## Author           : Ulrich Pfeifer
## Created On       : Mon May  6 15:35:44 1996
##
## Last Modified By : Norbert Goevert
## Last Modified On : Thu May 23 10:10:58 1996
##
## $State: Exp $
##
## $Id: IZ.pm,v 5.1 1996/11/05 16:55:03 goevert Exp goevert $
##
## $Log: IZ.pm,v $
## Revision 5.1  1996/11/05 16:55:03  goevert
## *** empty log message ***
##
## Revision 5.0.1.2  1996/05/23 17:07:12  goevert
## patch13: removed no strict 'vars';
##
## Revision 5.0.1.1  1996/05/13 11:27:11  goevert
## patch1:
##
########################################################################


package SFgate::Converter::IZ;


@KEYS    = (
            'ORGTIT',
            'TITDE',
            'ORGUTI',
            'UTIDE',
            '@ABSDE',
            'KLASSI',
            'LITISN',
            'ND',
            '@@@CE KINKEY',
            '@@@CB KINKEY',
            '@@@CB REIKEY',
            'SWVF  DESKEY',
           );

$Last_Key = @KEYS+1;
for (@KEYS) {
  $KEYS{$_} = $Last_Key--;
}

%VERBOSE = (
            'ORGTIT'      , 'Titel (original)',
            'TITDE'       , 'Titel (deutsch)',
            'ORGUTI'      , 'Untertitel (original)',
            'UTIDE'       , 'Untertitel (deutsch)',
            '@ABSDE'      , 'Referat',
            'KLASSI'      , 'Klassifikation',
            'LITISN'      , 0,
            'ND'          , 0,
            '@@@CE KINKEY', 0,
            '@@@CB KINKEY', 0,
            '@@@CB REIKEY', 0,
            'SWVF  DESKEY', 'Deskriptoren',
           );


## #####################################################################
## convert
## #####################################################################
## interface for SFgate to convert one document
##
## (string) $text:     document to convert
## (string) $headline: headline of document to convert
##
## By default every document is printed with its corresponding wais
## headline. If you want to derive another headline just change
## the $headline variable according to your needs.
##
## HTML special characters (&, <, >) should be encoded in text not
## being HTML code. To do this you can use the function
## &::encode_entities, e.g. $ntext = &::encode_entities($ntext)
## encodes the special chars in $ntext.
##
## returns:
## - string: the converted document ($ntext)
## - string: headline of converted document ($headline)
##
sub convert {
  my ($text, $headline) = @_;
  my ($lastkey, %text);

  for (split "\n", $text) {
    my $key = substr($_,0,12);
    my $val = substr($_,12);
    if ($key =~ /^\s+$/) {
      $key = $lastkey;
    } else {
      $key =~ s/\s+$//;
      $lastkey = $key;
    }
    $val =~ s/^\s+//;
    $text{$key} .= $val . ' ';
  }
  $headline = $text{'ORGTIT'} || $text{'TITDE'};
  my $key;
  $text = "<DL>\n";
  for $key (sort {$KEYS{$b} <=> $KEYS{$a}} keys %text) {
    my $label = $VERBOSE{$key} || $key;
    $text .= sprintf ("<DT><B>%s</B><DD>%s\n", $label, $text{$key});
  }
  $text .= "</DL>\n";
  return ($text, $headline);
}

