######################### -*- Mode: Perl -*- #########################
##
## File          : Makefile.PL
##
## Author        : Norbert Goevert
## Created On    : Mon Nov  9 16:04:27 1998
## Last Modified : Time-stamp: <2000-12-11 23:48:46 goevert>
##
## Description   : generates Makefile for RePrec
##
## $State$
##
## $Id: Makefile.PL 1.4 Mon, 11 Dec 2000 23:50:45 +0100 goevert $
##
## $Log$
######################################################################


use strict;

use ExtUtils::MakeMaker;
use File::Basename;


my @exe_files = grep { not /~$/ } glob('script/*');

# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.
WriteMakefile
  ( EXE_FILES    => [ @exe_files ],
    NAME         => 'RePrec',
    VERSION_FROM => 'lib/RePrec.pm', # finds $VERSION
    clean        => { FILES => '*/*/*/*/*~ */*/*/*~' },
  );


## ###################################################################
## subs
## ###################################################################

sub MY::postamble {

  '
ftpdist: dist
	rm -f /home-local/ftp/pub/src/Perl/$(DISTNAME)-*.tar$(SUFFIX)
	mv $(DISTVNAME).tar$(SUFFIX) /home-local/ftp/pub/src/Perl
'
  ;

}


__END__
## ###################################################################
## pod
## ###################################################################

=head1 NAME

Makefile.PL - generates Makefile for RePrec(3)

=head1 SEE ALSO

RePrec(3),
perl(1),
h2xs(1),
ls6h2xs(1),
ExtUtils::MakeMaker(3).

=head1 AUTHOR

Norbert Goevert E<lt>F<goevert@ls6.cs.uni-dortmund.de>E<gt>

=cut
