######################### -*- Mode: Perl -*- #########################
##
## File          : $Basename: muscat_stem.t $
##
## Author        : Norbert Gvert
## Created On    : Mon Nov 27 12:16:52 2000
## Last Modified : Time-stamp: <2000-11-27 17:23:22 goevert>
##
## Description   : regression tests for Muscat::Stem
##
## $Id: muscat_stem.t 1.2 Mon, 27 Nov 2000 17:30:18 +0100 goevert $
## $ProjectHeader: Muscat-Stem 0.3 Wed, 29 Nov 2000 10:00:08 +0100 goevert $
##
######################################################################


# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

use strict;

use Test;

######################### We start with some black magic to print on failure.

# Change `plan tests => 1' below to `plan tests => last_test_to_print'.
our $loaded;
BEGIN { $| = 1; plan tests => 3; }
END   { ok(0) unless $loaded; }
use Muscat::Stem qw( stem_danish
                     stem_dutch
                     stem_english
                     stem_french
                     stem_german
                     stem_italian
                     stem_norwegian
                     stem_porter
                     stem_portuguese
                     stem_spanish
                     stem_swedish
                   );
$loaded = 1;
ok(1);

######################### End of black magic.

# Insert your test code below (better if it prints "ok 13"
# (correspondingly "not ok 13") depending on the success of chunk 13
# of the test code):

my @a;

@a = qw(computer compute ice retrieval information);
print 'ENGLISH STEMS: ', join(':', stem_english(@a)),      "\n";
ok( join(':', stem_english(@a)),
    'comput:comput:ice:retriev:inform'
  );

@a = qw(computer dokumente dokumentieren informationen);
print 'TERMS:         ', join(':', @a),            "\n";
print 'GERMAN STEMS:  ', join(':', stem_german(@a)), "\n";
ok( join(':', stem_german(@a)),
    'comput:dokument:dokumenti:information'
  );
