######################### -*- Mode: Perl -*- #########################
##
## File          : $Basename: Stem.pm $
##
## Author        : Norbert Gvert
## Created On    : Mon Nov 27 12:16:52 2000
## Last Modified : Time-stamp: <2000-11-27 16:19:56 goevert>
##
## Description   : 
##
## $Id: Stem.pm 1.1 Mon, 27 Nov 2000 17:18:18 +0100 goevert $
## $ProjectHeader: Muscat-Stem 0.3 Wed, 29 Nov 2000 10:00:08 +0100 goevert $
##
######################################################################


use strict;


=pod #---------------------------------------------------------------#

=head1 NAME

Muscat::Stem - provides perl interface to Muscat stemmers

=head1 SYNOPSIS

  require Muscat::Stem;

=head1 DESCRIPTION

Muscat::Stem provides a perl interface to the various stemmers from
the Muscat project (http://open.muscat.com/).

=head1 FUNCTIONS

=over

item @stemmed = stem_danish(@terms)

item @stemmed = stem_dutch(@terms)

item @stemmed = stem_english(@terms)

item @stemmed = stem_french(@terms)

item @stemmed = stem_german(@terms)

item @stemmed = stem_italian(@terms)

item @stemmed = stem_norwegian(@terms)

item @stemmed = stem_porter(@terms)

item @stemmed = stem_portuguese(@terms)

item @stemmed = stem_spanish(@terms)

item @stemmed = stem_swedish(@terms)

reduces I<@words> to their stems using the well known Porter
algorithm, adapted for the various languages.

  AU: Porter, M. F.
  TI: An Algorithm for Suffix Stripping
  JT: Program
  VO: 14
  PP: 130-137
  PY: 1980
  PM: JUL
  CN: http://www.muscat.com/~martin/stem.html

=back

=head1 BUGS

Yes. Please let me know!

=head1 SEE ALSO

perl(1).

=head1 AUTHOR

Norbert GE<ouml>vert E<lt>F<goevert@ls6.cs.uni-dortmund.de>E<gt>

=cut #---------------------------------------------------------------#


package Muscat::Stem;


use base qw(Exporter DynaLoader);

our $VERSION;
'$ProjectVersion: 0.3 $ ' =~ /(\d+)\.(\d+)/; $VERSION = sprintf '%d.%03d', $1, $2;

bootstrap Muscat::Stem $VERSION;

our @EXPORT_OK = qw( stem_danish
                     stem_dutch
                     stem_english
                     stem_french
                     stem_german
                     stem_italian
                     stem_norwegian
                     stem_porter
                     stem_portuguese
                     stem_spanish
                     stem_swedish
                   );


1;
__END__
