#include "protos.h"

/*
 * This software is Copyright (C) 1988 by Steven Dorner and the
 * University of Illinois Board of Trustees, and by CSNET.  No warranties of
 * any kind are expressed or implied.  No support will be provided.
 * This software may not be redistributed without prior consent of CSNET.
 * You may direct questions to nameserv@uiuc.edu
 */

#ifdef __STDC__
#include <stdarg.h>
#else
#include <varargs.h>
#endif

static char Delimiters[] = "  ,.:()&#;\n";

char *
make_str(str)
	char *str;
{
	char	*ptr;
	int	len;

	len = str ? strlen(str) : 1;
	if (!(ptr = malloc((unsigned) len + 1)))
	{
		IssueMessage(LOG_ERR, "HELP! out of memory !\n");
		return (NULL);
	}
	strcpy(ptr, str ? str : "");
	return (ptr);
}

void 
free_ary(ary)
	long **ary;
{
	register int i;

	for (i = 0; ary[i]; i++)
	{
		if (ary[i] != (void *) NIL)
			free(ary[i]);
		ary[i] = 0;
	}
}

int 
length(ary)
	long *ary;
{
	int	len;

	if (!ary)
		return (0);
	for (len = 0; *ary++; len++) ;

	return (len);
}

char *
getword(str, buf)
	char *str, *buf;
{
	register i = 0;

	/* skip extraneous beginnings */
	while (*str && any(*str, Delimiters))
		str++;

	if (*str == '\"')
	{			/* this is a quoted string */
		do
		{		/* grab up to next quote */
			*buf++ = *str++;
			if (++i >= (WORDSIZE - 1))	/* limit word length */
				break;
			if (*str == '\"')
			{
				if (*++str != '\"')
				{	/* not quoted quote */
					*buf++ = '\"';
					break;
				}
			}
		}
		while (*str);

	} else
	{
		/* copy until uninteresting char found */
		while (*str && !any(*str, Delimiters))
		{
			*buf++ = *str++;
			if (++i >= (WORDSIZE - 1))	/* limit word length */
				break;
		}
	}

	*buf = '\0';
	return (str);
}


/*
 * if the string is quoted, strip the quotes in place and return 1 else 0
 */
int 
quoted(str)
	char *str;
{
	register char *ptr = str;

	if (*str != '\"')
		return 0;
	while (*ptr = *++str)
		ptr++;
	if (ptr[-1] == '\"')
		ptr[-1] = '\0';
	return 1;
}


/*
 * This function returns an index into the index file for string str limit is
 * the max integer - 1 allowable. returns 1 <= x <= limit-1
 */

#define SEED  341		/* it's something isn't it? */

long 
ihash(str, seed, limit)
	char *str;
	long seed, limit;
{
	int	i;

	for (i = seed; *str; str++)
	{
		i = i * SEED + (isupper(*str) ? tolower(*str) : *str);
	}
	if (i < 0)
		i = -i;
	return (i % (limit - 1) + 1);	/* zero not allowed */
}

static int SysLog = 1;
int 
DoSysLog(yes)
	int yes;
{
	SysLog = yes;
}

#ifdef __STDC__
int 
IssueMessage(int severity, char *fmt,...)
#else /* !__STDC__ */
int 
IssueMessage(severity, fmt, va_alist)
	int severity;
	char *fmt;
va_dcl
#endif /* __STDC__ */
{
	va_list	args;
	extern int DontLog;	/* qi.c */

	if (DontLog)
		return (0);
#ifdef __STDC__
	va_start(args, fmt);
#else /* !__STDC__ */
	va_start(args);
#endif /* __STDC__ */
	if (SysLog)
	{
		char	buffer[4096];

		vsprintf(buffer, fmt, args);
		syslog(severity, "%s", buffer);
	} else
	{
		fprintf(stderr, "Severity %d: ", severity);
		vfprintf(stderr, fmt, args);
		fputs("\n", stderr);
	}
	va_end(args);
	return (0);
}
