/*---------------------------------------------------------------------------
Ph.h - Header file for Ph.m class.
-----------------------------------------------------------------------------*/
#import <objc/Object.h>

@interface Ph:Object
{
   id    serversMenuCell;	/* Servers menu cell */
   
   id    infoPanel;		/* Info panel object (separate nib file) */
   id    helpIntroPanel;	/* Help Intro panel object (separate nib file) */
   id    helpServerMgr;		/* Manager of the HelpSever object */
   id    phAnimator;            /* Animator for myself */
   id    prefs;			/* Prefs object (separate nib file) */
   id    qiManager;		/* Manager of the Qi server objects */
   id    queryManager;		/* Query Manager object (separate nib file) */
   id    servers;		/* Servers object (separate nib file) */
   id    speakerQueryId;	/* Query ID for current Speaker request */

   const char *defaultServer;   /* Default CSO Nameserver */
   char  errMsg[256];		/* Alert panel error message string */
   BOOL  unhiddenOnce;		/* First time unhidden? */
   char *speakerCommand;	/* Command from some other app's Speaker */
   char *speakerServer;		/* Server from some other app's Speaker */
   char *speakerSite;		/* Site from some other app's Speaker */
}

+ initialize;
- init;

- appDidInit:sender;
- appDidUnhide:sender;

- checkExpiration:sender;

- clearBuffer:sender;
- clearFields:sender;

- showHelpIntro:sender;
- showHelpServer:sender;
- showInfo:sender;
- showPrefs:sender;
- showServers:sender;

- appWillTerminate:sender;

/*** Services methods. */
- phQueryService:(id)pb userData:(const char *)userData error:(char **)msg;

/*** Speaker/Listener methods. */

- (int) hide;
- (int) unhide;

- (int) addServer:(char *)aServer site:(char *)aSite ok:(int *)flag;
- (int) getServers:(char **)serverNames sites:(char **)siteNames ok:(int *)flag;

- (int) queryServer:(char *)aServer site:(char *)aSite command:(char *)aCommand ok:(int *)flag;
- (int) showServer:(char *)aServer site:(char *)aSite ok:(int *)flag;

/*** Timer methods used to support the Speaker/Listener methods. */

- phTimeCheck;
- startPhTimer:sender;
- stopPhTimer:sender;

@end
